/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.history;

import java.util.HashMap;
import java.util.List;
import org.eximeebpms.bpm.engine.history.HistoricActivityInstance;
import org.eximeebpms.bpm.engine.history.HistoricActivityInstanceQuery;
import org.eximeebpms.bpm.engine.history.HistoricDetail;
import org.eximeebpms.bpm.engine.history.HistoricVariableInstance;
import org.eximeebpms.bpm.engine.history.HistoricVariableInstanceQuery;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.history.HistoryLevel;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.runtime.CaseExecution;
import org.eximeebpms.bpm.engine.runtime.CaseInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

@RequiredHistoryLevel(value="audit")
public class HistoricVariableInstanceScopeTest
extends PluggableProcessEngineTest {
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSetVariableOnProcessInstanceStart() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("testVar", "testValue");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assert.assertEquals((long)1L, (long)query.count());
        HistoricVariableInstance variable = (HistoricVariableInstance)query.singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)pi.getId(), (Object)variable.getActivityInstanceId());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSetVariableLocalOnUserTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariableLocal(task.getId(), "testVar", (Object)"testValue");
        ExecutionEntity taskExecution = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(task.getExecutionId()).singleResult();
        Assert.assertNotNull((Object)taskExecution);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assert.assertEquals((long)1L, (long)query.count());
        HistoricVariableInstance variable = (HistoricVariableInstance)query.singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)taskExecution.getActivityInstanceId(), (Object)variable.getActivityInstanceId());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSetVariableOnProcessIntanceStartAndSetVariableLocalOnUserTask() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("testVar", "testValue");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariableLocal(task.getId(), "testVar", (Object)"anotherTestValue");
        ExecutionEntity taskExecution = (ExecutionEntity)this.runtimeService.createExecutionQuery().singleResult();
        Assert.assertNotNull((Object)taskExecution);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assert.assertEquals((long)2L, (long)query.count());
        List result = query.list();
        HistoricVariableInstance firstVar = (HistoricVariableInstance)result.get(0);
        Assert.assertEquals((Object)"testVar", (Object)firstVar.getVariableName());
        Assert.assertEquals((Object)"testValue", (Object)firstVar.getValue());
        Assert.assertEquals((Object)pi.getId(), (Object)firstVar.getActivityInstanceId());
        HistoricVariableInstance secondVar = (HistoricVariableInstance)result.get(1);
        Assert.assertEquals((Object)"testVar", (Object)secondVar.getVariableName());
        Assert.assertEquals((Object)"anotherTestValue", (Object)secondVar.getValue());
        Assert.assertEquals((Object)taskExecution.getActivityInstanceId(), (Object)secondVar.getActivityInstanceId());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneSubProcess.bpmn20.xml"})
    @Test
    public void testSetVariableOnUserTaskInsideSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("startSimpleSubProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "testVar", (Object)"testValue");
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assert.assertEquals((long)1L, (long)query.count());
        HistoricVariableInstance variable = (HistoricVariableInstance)query.singleResult();
        Assert.assertEquals((Object)pi.getId(), (Object)variable.getActivityInstanceId());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testSetVariableOnServiceTaskInsideSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assert.assertEquals((long)1L, (long)query.count());
        HistoricVariableInstance variable = (HistoricVariableInstance)query.singleResult();
        Assert.assertEquals((Object)pi.getId(), (Object)variable.getActivityInstanceId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testSetVariableLocalOnServiceTaskInsideSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assert.assertEquals((long)1L, (long)query.count());
        String activityInstanceId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("SubProcess_1").singleResult()).getId();
        HistoricVariableInstance variable = (HistoricVariableInstance)query.singleResult();
        Assert.assertEquals((Object)activityInstanceId, (Object)variable.getActivityInstanceId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testSetVariableLocalOnTaskInsideParallelBranch() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariableLocal(task.getId(), "testVar", (Object)"testValue");
        ExecutionEntity taskExecution = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(task.getExecutionId()).singleResult();
        Assert.assertNotNull((Object)taskExecution);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assert.assertEquals((long)1L, (long)query.count());
        HistoricVariableInstance variable = (HistoricVariableInstance)query.singleResult();
        Assert.assertEquals((Object)taskExecution.getActivityInstanceId(), (Object)variable.getActivityInstanceId());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricVariableInstanceScopeTest.testSetVariableLocalOnTaskInsideParallelBranch.bpmn"})
    @Test
    public void testSetVariableOnTaskInsideParallelBranch() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "testVar", (Object)"testValue");
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assert.assertEquals((long)1L, (long)query.count());
        HistoricVariableInstance variable = (HistoricVariableInstance)query.singleResult();
        Assert.assertEquals((Object)pi.getId(), (Object)variable.getActivityInstanceId());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testSetVariableOnServiceTaskInsideParallelBranch() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assert.assertEquals((long)1L, (long)query.count());
        HistoricVariableInstance variable = (HistoricVariableInstance)query.singleResult();
        Assert.assertEquals((Object)pi.getId(), (Object)variable.getActivityInstanceId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testSetVariableLocalOnServiceTaskInsideParallelBranch() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        HistoricActivityInstance serviceTask = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("serviceTask1").singleResult();
        Assert.assertNotNull((Object)serviceTask);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assert.assertEquals((long)1L, (long)query.count());
        HistoricVariableInstance variable = (HistoricVariableInstance)query.singleResult();
        Assert.assertEquals((Object)serviceTask.getId(), (Object)variable.getActivityInstanceId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testHistoricCaseVariableInstanceQuery() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("foo", "bar");
        String caseInstanceId = this.caseService.createCaseInstanceByKey("oneTaskCase", variables).getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("CasePlanModel_1").singleResult()).getId();
        String taskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.setVariableLocal(caseExecutionId, "case", (Object)"execution");
        this.caseService.setVariableLocal(taskExecutionId, "task", (Object)"execution");
        this.caseService.setVariableLocal(caseExecutionId, "case", (Object)"update");
        this.caseService.setVariableLocal(taskExecutionId, "task", (Object)"update");
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricVariableInstanceQuery().caseInstanceId(caseInstanceId).count());
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId, taskExecutionId}).count());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().caseExecutionIdIn(new String[]{taskExecutionId}).count());
        HistoryLevel historyLevel = this.processEngineConfiguration.getHistoryLevel();
        if (historyLevel.equals(HistoryLevel.HISTORY_LEVEL_FULL)) {
            Assert.assertEquals((long)5L, (long)this.historyService.createHistoricDetailQuery().count());
            Assert.assertEquals((long)5L, (long)this.historyService.createHistoricDetailQuery().caseInstanceId(caseInstanceId).count());
            Assert.assertEquals((long)3L, (long)this.historyService.createHistoricDetailQuery().caseExecutionId(caseExecutionId).count());
            Assert.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().caseExecutionId(taskExecutionId).count());
        }
    }

    @Deployment
    @Test
    public void testInputMappings() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        HistoricActivityInstanceQuery activityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId);
        String theService1Id = ((HistoricActivityInstance)activityInstanceQuery.activityId("theService1").singleResult()).getId();
        String theService2Id = ((HistoricActivityInstance)activityInstanceQuery.activityId("theService2").singleResult()).getId();
        String theTaskId = ((HistoricActivityInstance)activityInstanceQuery.activityId("theTask").singleResult()).getId();
        HistoricVariableInstance firstVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("firstInputVariable").singleResult();
        Assert.assertEquals((Object)theService1Id, (Object)firstVariable.getActivityInstanceId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            HistoricDetail firstVariableDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableUpdates().variableInstanceId(firstVariable.getId()).singleResult();
            Assert.assertEquals((Object)theService1Id, (Object)firstVariableDetail.getActivityInstanceId());
        }
        HistoricVariableInstance secondVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("secondInputVariable").singleResult();
        Assert.assertEquals((Object)theService2Id, (Object)secondVariable.getActivityInstanceId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            HistoricDetail secondVariableDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableUpdates().variableInstanceId(secondVariable.getId()).singleResult();
            Assert.assertEquals((Object)theService2Id, (Object)secondVariableDetail.getActivityInstanceId());
        }
        HistoricVariableInstance thirdVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("thirdInputVariable").singleResult();
        Assert.assertEquals((Object)theTaskId, (Object)thirdVariable.getActivityInstanceId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            HistoricDetail thirdVariableDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableUpdates().variableInstanceId(thirdVariable.getId()).singleResult();
            Assert.assertEquals((Object)theTaskId, (Object)thirdVariableDetail.getActivityInstanceId());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCmmnActivityInstanceIdOnCaseInstance() {
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase");
        String taskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(taskExecutionId).setVariable("foo", (Object)"bar").execute();
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("foo").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)caseInstance.getId(), (Object)variable.getActivityInstanceId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            HistoricDetail variableDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableUpdates().variableInstanceId(variable.getId()).singleResult();
            Assert.assertEquals((Object)taskExecutionId, (Object)variableDetail.getActivityInstanceId());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCmmnActivityInstanceIdOnCaseExecution() {
        this.caseService.createCaseInstanceByKey("oneTaskCase");
        String taskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(taskExecutionId).setVariableLocal("foo", (Object)"bar").execute();
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("foo").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)taskExecutionId, (Object)variable.getActivityInstanceId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            HistoricDetail variableDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableUpdates().variableInstanceId(variable.getId()).singleResult();
            Assert.assertEquals((Object)taskExecutionId, (Object)variableDetail.getActivityInstanceId());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCmmnActivityInstanceIdOnTask() {
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase");
        String taskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariable(task.getId(), "foo", (Object)"bar");
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("foo").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)caseInstance.getId(), (Object)variable.getActivityInstanceId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            HistoricDetail variableDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableUpdates().variableInstanceId(variable.getId()).singleResult();
            Assert.assertEquals((Object)taskExecutionId, (Object)variableDetail.getActivityInstanceId());
        }
    }
}

