/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.history;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngineConfiguration;
import org.eximeebpms.bpm.engine.history.HistoricJobLog;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.history.event.HostnameProvider;
import org.eximeebpms.bpm.engine.impl.metrics.MetricsReporterIdProvider;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;
import org.eximeebpms.bpm.engine.management.MetricIntervalValue;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HostnameProviderTest {
    public static final String ENGINE_NAME = "TEST_ENGINE";
    public static final String STATIC_HOSTNAME = "STATIC";
    public static final String CUSTOM_HOSTNAME = "CUSTOM_HOST";
    public static final String CUSTOM_REPORTER = "CUSTOM_REPORTER";
    @Parameterized.Parameter(value=0)
    public String hostname;
    @Parameterized.Parameter(value=1)
    public HostnameProvider hostnameProvider;
    @Parameterized.Parameter(value=2)
    public MetricsReporterIdProvider reporterProvider;
    @Parameterized.Parameter(value=3)
    public String expectedHostname;
    @Parameterized.Parameter(value=4)
    public String expectedReporter;
    protected ProcessEngineConfigurationImpl configuration;
    protected ProcessEngine engine;
    protected ManagementService managementService;

    @Parameterized.Parameters(name="Expected hostname: {3}, reporter: {4}")
    public static Collection<Object[]> data() {
        return Arrays.asList({null, null, null, ENGINE_NAME, ENGINE_NAME}, {STATIC_HOSTNAME, null, null, STATIC_HOSTNAME, STATIC_HOSTNAME}, {STATIC_HOSTNAME, new CustomHostnameProvider(), null, STATIC_HOSTNAME, STATIC_HOSTNAME}, {STATIC_HOSTNAME, new CustomHostnameProvider(), new CustomMetricsReporterIdProvider(), STATIC_HOSTNAME, STATIC_HOSTNAME}, {STATIC_HOSTNAME, null, new CustomMetricsReporterIdProvider(), STATIC_HOSTNAME, STATIC_HOSTNAME}, {null, new CustomHostnameProvider(), null, CUSTOM_HOSTNAME, CUSTOM_HOSTNAME}, {null, new CustomHostnameProvider(), new CustomMetricsReporterIdProvider(), CUSTOM_HOSTNAME, CUSTOM_HOSTNAME}, {null, null, new CustomMetricsReporterIdProvider(), ENGINE_NAME, CUSTOM_REPORTER});
    }

    @Before
    public void setUp() {
        this.configuration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createStandaloneInMemProcessEngineConfiguration();
        this.configuration.setJdbcUrl("jdbc:h2:mem:eximeebpms" + this.getClass().getSimpleName() + "testHostnameProvider").setProcessEngineName(ENGINE_NAME).setHostname(this.hostname).setHostnameProvider(this.hostnameProvider).setMetricsReporterIdProvider(this.reporterProvider);
        this.engine = this.configuration.buildProcessEngine();
        this.configuration.getMetricsRegistry().markOccurrence("TEST", 1L);
        this.configuration.getDbMetricsReporter().reportNow();
        this.managementService = this.configuration.getManagementService();
    }

    @After
    public void tearDown() {
        this.closeProcessEngine();
    }

    @Test
    public void shouldUseCustomHostname() {
        String customHostname = this.configuration.getHostname();
        Assertions.assertThat((String)customHostname).containsIgnoringCase((CharSequence)this.expectedHostname);
    }

    @Test
    public void shouldUseCustomMetricsReporterId() {
        List metrics = this.managementService.createMetricsQuery().limit(1).interval();
        Assertions.assertThat((List)metrics).hasSize(1);
        Assertions.assertThat((String)((MetricIntervalValue)metrics.get(0)).getReporter()).containsIgnoringCase((CharSequence)this.expectedReporter);
    }

    protected void closeProcessEngine() {
        HistoryService historyService = this.engine.getHistoryService();
        this.configuration.getCommandExecutorTxRequired().execute(commandContext -> {
            List jobs = historyService.findHistoryCleanupJobs();
            for (Job job : jobs) {
                commandContext.getJobManager().deleteJob((JobEntity)job);
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(job.getId());
            }
            List list = historyService.createHistoricJobLogQuery().list();
            for (HistoricJobLog jobLog : list) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobLog.getJobId());
            }
            commandContext.getMeterLogManager().deleteAll();
            return null;
        });
        this.engine.close();
        this.engine = null;
    }

    public static class CustomHostnameProvider
    implements HostnameProvider {
        public String getHostname(ProcessEngineConfigurationImpl processEngineConfiguration) {
            return HostnameProviderTest.CUSTOM_HOSTNAME;
        }
    }

    public static class CustomMetricsReporterIdProvider
    implements MetricsReporterIdProvider {
        public String provideId(ProcessEngine processEngine) {
            return HostnameProviderTest.CUSTOM_REPORTER;
        }
    }
}

