/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.history.dmn;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.eximeebpms.bpm.engine.history.HistoricDecisionInstance;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class HistoricDecisionInstanceReturnBlankTableOutputAsNullTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(config -> config.setDmnReturnBlankTableOutputAsNull(true));
    @Rule
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    public static final String RESULT_TEST_DMN = "org/eximeebpms/bpm/engine/test/history/ReturnBlankTableOutputAsNull.dmn";

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/ReturnBlankTableOutputAsNull.dmn"})
    public void shouldReturnNullWhenExpressionIsNull() {
        this.engineRule.getDecisionService().evaluateDecisionByKey("Decision_0vmcc71").variables((Map)Variables.putValue((String)"name", (Object)"A")).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.engineRule.getProcessEngine().getHistoryService().createHistoricDecisionInstanceQuery().includeOutputs().singleResult();
        Assertions.assertThat((List)historicDecisionInstance.getOutputs()).extracting(new String[]{"variableName", "value"}).containsOnly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"output", null})});
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/ReturnBlankTableOutputAsNull.dmn"})
    public void shouldReturnNullWhenTextTagEmpty() {
        this.engineRule.getDecisionService().evaluateDecisionByKey("Decision_0vmcc71").variables((Map)Variables.putValue((String)"name", (Object)"B")).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.engineRule.getProcessEngine().getHistoryService().createHistoricDecisionInstanceQuery().includeOutputs().singleResult();
        Assertions.assertThat((List)historicDecisionInstance.getOutputs()).extracting(new String[]{"variableName", "value"}).containsOnly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"output", null})});
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/ReturnBlankTableOutputAsNull.dmn"})
    public void shouldReturnEmpty() {
        this.engineRule.getDecisionService().evaluateDecisionByKey("Decision_0vmcc71").variables((Map)Variables.putValue((String)"name", (Object)"C")).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.engineRule.getProcessEngine().getHistoryService().createHistoricDecisionInstanceQuery().includeOutputs().singleResult();
        Assertions.assertThat((List)historicDecisionInstance.getOutputs()).extracting(new String[]{"variableName", "value"}).containsOnly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"output", ""})});
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/ReturnBlankTableOutputAsNull.dmn"})
    public void shouldReturnNullWhenOutputEntryEmpty() {
        this.engineRule.getDecisionService().evaluateDecisionByKey("Decision_0vmcc71").variables((Map)Variables.putValue((String)"name", (Object)"D")).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.engineRule.getProcessEngine().getHistoryService().createHistoricDecisionInstanceQuery().includeOutputs().singleResult();
        Assertions.assertThat((List)historicDecisionInstance.getOutputs()).extracting(new String[]{"variableName", "value"}).containsOnly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"output", null})});
    }
}

