/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.logging;

import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Java6Assertions;
import org.eximeebpms.commons.logging.MdcAccess;

public class TestMdcFacade {
    private final Map<String, String> keyValuePairs = new HashMap<String, String>();

    private TestMdcFacade() {
    }

    public static TestMdcFacade empty() {
        return new TestMdcFacade();
    }

    public static TestMdcFacade defaultLoggingContextParameters(String activityId, String activityName, String applicationName, String businessKey, String processDefinitionId, String processDefinitionKey, String processInstanceId, String tenantId, String engineName) {
        return new TestMdcFacade().withDefaultLoggingContextParameters(activityId, activityName, applicationName, businessKey, processDefinitionId, processDefinitionKey, processInstanceId, tenantId, engineName);
    }

    public TestMdcFacade withDefaultLoggingContextParameters(String activityId, String activityName, String applicationName, String businessKey, String processDefinitionId, String processDefinitionKey, String processInstanceId, String tenantId, String engineName) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("activityId", activityId);
        result.put("activityName", activityName);
        result.put("applicationName", applicationName);
        result.put("businessKey", businessKey);
        result.put("processDefinitionId", processDefinitionId);
        result.put("processDefinitionKey", processDefinitionKey);
        result.put("processInstanceId", processInstanceId);
        result.put("tenantId", tenantId);
        result.put("engineName", engineName);
        return this.withMDCProperties(result);
    }

    public TestMdcFacade withMDCProperties(Map<String, String> keyValuePairs) {
        this.keyValuePairs.putAll(keyValuePairs);
        this.keyValuePairs.forEach(MdcAccess::put);
        return this;
    }

    public TestMdcFacade withMDCProperty(String key, String value) {
        this.keyValuePairs.put(key, value);
        MdcAccess.put((String)key, (String)value);
        return this;
    }

    public void clear() {
        this.keyValuePairs.forEach((k, v) -> MdcAccess.remove((String)k));
    }

    public void assertAllInsertedPropertiesAreInMdc() {
        this.keyValuePairs.forEach((k, v) -> Java6Assertions.assertThat((String)MdcAccess.get((String)k)).isNotNull());
    }
}

