/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.exceptions.PersistenceException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.eximeebpms.bpm.engine.AuthorizationService;
import org.eximeebpms.bpm.engine.FilterService;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.authorization.Authorization;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.authorization.TaskPermissions;
import org.eximeebpms.bpm.engine.filter.Filter;
import org.eximeebpms.bpm.engine.identity.User;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.history.event.HistoricDetailEventEntity;
import org.eximeebpms.bpm.engine.impl.history.event.HistoricVariableUpdateEventEntity;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandExecutor;
import org.eximeebpms.bpm.engine.impl.test.RequiredDatabase;
import org.eximeebpms.bpm.engine.runtime.NativeProcessInstanceQuery;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class SuppressSqlExceptionsTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule engineTestRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.engineTestRule);
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected RepositoryService repositoryService;
    protected FilterService filterService;
    protected IdentityService identityService;
    protected AuthorizationService authorizationService;
    protected ProcessEngineConfigurationImpl engineConfig;
    protected boolean batchProcessingEnabled;
    protected Map<String, String> keptStatementMappings;

    @Before
    public void assignServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.filterService = this.engineRule.getFilterService();
        this.identityService = this.engineRule.getIdentityService();
        this.authorizationService = this.engineRule.getAuthorizationService();
        this.engineConfig = this.engineRule.getProcessEngineConfiguration();
        this.batchProcessingEnabled = this.engineConfig.isJdbcBatchProcessing();
    }

    @Before
    public void keepStatementMappings() {
        Map statementMappings = this.engineRule.getProcessEngineConfiguration().getDbSqlSessionFactory().getStatementMappings();
        if (this.keptStatementMappings == null) {
            this.keptStatementMappings = statementMappings;
        }
        this.engineRule.getProcessEngineConfiguration().getDbSqlSessionFactory().setStatementMappings(this.keptStatementMappings == null ? new HashMap() : new HashMap<String, String>(this.keptStatementMappings));
    }

    @After
    public void resetStatementMappings() {
        this.engineConfig.getDbSqlSessionFactory().setStatementMappings(this.keptStatementMappings);
    }

    @Test
    public void shouldThrowExceptionOnSelectingById() {
        this.failForSqlStatement("selectJob");
        Iterator<Throwable> exceptionsByHierarchy = this.catchExceptionHierarchy(() -> this.managementService.executeJob("anId"));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(ProcessEngineException.class)).hasMessage("An exception occurred in the persistence layer. Please check the server logs for a detailed message and the entire exception stack trace.");
        Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(PersistenceException.class);
    }

    @Test
    public void shouldThrowExceptionOnSelectionWithListInReturn() {
        Iterator<Throwable> exceptionsByHierarchy = this.catchExceptionHierarchy(() -> ((NativeProcessInstanceQuery)this.runtimeService.createNativeProcessInstanceQuery().sql("foo")).list());
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(ProcessEngineException.class)).hasMessage("An exception occurred in the persistence layer. Please check the server logs for a detailed message and the entire exception stack trace.");
        Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(PersistenceException.class);
    }

    @Test
    public void shouldThrowExceptionOnSingleRowSelection() {
        this.failForSqlStatement("selectDeploymentCountByQueryCriteria");
        Iterator<Throwable> exceptionsByHierarchy = this.catchExceptionHierarchy(() -> this.repositoryService.createDeploymentQuery().count());
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(ProcessEngineException.class)).hasMessage("An exception occurred in the persistence layer. Please check the server logs for a detailed message and the entire exception stack trace.");
        Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(PersistenceException.class);
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void shouldThrowExceptionOnInsert_ColumnSizeExceeded() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.engineTestRule.deploy(modelInstance);
        String businessKey = this.generateString(1000);
        Iterator<Throwable> exceptionsByHierarchy = this.catchExceptionHierarchy(() -> this.runtimeService.startProcessInstanceByKey("process", businessKey));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(ProcessEngineException.class)).hasMessage("An exception occurred in the persistence layer. Please check the server logs for a detailed message and the entire exception stack trace.");
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("ENGINE-03004 Exception while executing Database Operation 'INSERT HistoricProcessInstanceEventEntity").hasMessageContaining("Flush summary: ");
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(PersistenceException.class)).hasMessageContaining("insertHistoricProcessInstanceEvent");
    }

    @Test
    public void shouldThrowExceptionOnInsert_UniqueConstraintViolated() {
        Authorization authorizationOne = this.authorizationService.createNewAuthorization(1);
        authorizationOne.setGroupId("aUserId");
        authorizationOne.setPermissions(new Permission[]{TaskPermissions.READ});
        authorizationOne.setResourceId("foo");
        authorizationOne.setResource((Resource)Resources.TASK);
        this.authorizationService.saveAuthorization(authorizationOne);
        Authorization authorizationTwo = this.authorizationService.createNewAuthorization(1);
        authorizationTwo.setGroupId("aUserId");
        authorizationTwo.setPermissions(new Permission[]{TaskPermissions.READ});
        authorizationTwo.setResourceId("foo");
        authorizationTwo.setResource((Resource)Resources.TASK);
        Iterator<Throwable> exceptionsByHierarchy = this.catchExceptionHierarchy(() -> this.authorizationService.saveAuthorization(authorizationTwo));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(ProcessEngineException.class)).hasMessage("An exception occurred in the persistence layer. Please check the server logs for a detailed message and the entire exception stack trace.");
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("ENGINE-03004 Exception while executing Database Operation 'INSERT AuthorizationEntity").hasMessageContaining("Flush summary: ");
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(PersistenceException.class)).hasMessageContaining("insertAuthorization");
        this.authorizationService.deleteAuthorization(authorizationOne.getId());
    }

    @Test
    public void shouldThrowExceptionOnDelete() {
        this.failForSqlStatement("deleteFilter");
        Filter foo = this.filterService.newTaskFilter("foo");
        this.filterService.saveFilter(foo);
        Iterator<Throwable> exceptionsByHierarchy = this.catchExceptionHierarchy(() -> this.filterService.deleteFilter(foo.getId()));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(ProcessEngineException.class)).hasMessage("An exception occurred in the persistence layer. Please check the server logs for a detailed message and the entire exception stack trace.");
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining(this.batchProcessingEnabled ? "ENGINE-03083 Unexpected exception while executing database operations with message '" : "ENGINE-03004 Exception while executing Database Operation '").hasMessageContaining("Flush summary: ");
        Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(PersistenceException.class);
        this.resetStatementMappings();
        this.filterService.deleteFilter(foo.getId());
    }

    @Test
    public void shouldThrowExceptionOnBulkDelete() {
        this.failForSqlStatement("deleteMembershipsByUserId");
        User user = this.identityService.newUser("foo");
        this.identityService.saveUser(user);
        Iterator<Throwable> exceptionsByHierarchy = this.catchExceptionHierarchy(() -> this.identityService.deleteUser("foo"));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(ProcessEngineException.class)).hasMessage("An exception occurred in the persistence layer. Please check the server logs for a detailed message and the entire exception stack trace.");
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining(this.batchProcessingEnabled ? "ENGINE-03083 Unexpected exception while executing database operations with message '" : "ENGINE-03004 Exception while executing Database Operation '").hasMessageContaining("Flush summary: ");
        Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(PersistenceException.class);
        this.resetStatementMappings();
        this.engineRule.getIdentityService().deleteUser("foo");
    }

    @Test
    public void shouldThrowExceptionOnUpdate() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
        this.engineTestRule.deploy(modelInstance);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.putValue((String)"foo", (Object)"bar")).getId();
        String variableValue = this.generateString(10000);
        CommandExecutor commandExecutor = this.engineConfig.getCommandExecutorTxRequired();
        Iterator<Throwable> exceptionsByHierarchy = this.catchExceptionHierarchy(() -> commandExecutor.execute(c -> {
            this.runtimeService.setVariable(processInstanceId, "foo", (Object)variableValue);
            this.trimHistoricDetailValue(c);
            return null;
        }));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("An exception occurred in the persistence layer. Please check the server logs for a detailed message and the entire exception stack trace.");
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("ENGINE-03004 Exception while executing Database Operation 'UPDATE VariableInstanceEntity").hasMessageContaining("Flush summary: ");
        Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(PersistenceException.class);
    }

    private void trimHistoricDetailValue(CommandContext c) {
        List historicDetails = c.getDbEntityManager().getCachedEntitiesByType(HistoricDetailEventEntity.class);
        if (!historicDetails.isEmpty()) {
            HistoricVariableUpdateEventEntity detail = (HistoricVariableUpdateEventEntity)historicDetails.get(0);
            detail.setTextValue("");
        }
    }

    @Test
    public void shouldThrowExceptionOnBulkUpdate() {
        this.failForSqlStatement("updateProcessDefinitionSuspensionStateByParameters");
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.engineTestRule.deploy(modelInstance);
        Iterator<Throwable> exceptionsByHierarchy = this.catchExceptionHierarchy(() -> this.repositoryService.updateProcessDefinitionSuspensionState().byProcessDefinitionKey("process").suspend());
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(ProcessEngineException.class)).hasMessage("An exception occurred in the persistence layer. Please check the server logs for a detailed message and the entire exception stack trace.");
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining(this.batchProcessingEnabled ? "ENGINE-03083 Unexpected exception while executing database operations with message '" : "ENGINE-03004 Exception while executing Database Operation '").hasMessageContaining("Flush summary: ");
        Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(PersistenceException.class);
    }

    @Test
    @RequiredDatabase(excludes={"h2"})
    public void shouldThrowExceptionOnLock() {
        this.failForSqlStatement("lockDeploymentLockProperty");
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
        Iterator<Throwable> exceptionsByHierarchy = this.catchExceptionHierarchy(() -> this.repositoryService.createDeployment().addModelInstance("process.bpmn", modelInstance).deploy());
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(ProcessEngineException.class)).hasMessage("An exception occurred in the persistence layer. Please check the server logs for a detailed message and the entire exception stack trace.");
        Assertions.assertThat((Throwable)exceptionsByHierarchy.next()).isInstanceOf(PersistenceException.class);
    }

    protected Iterator<Throwable> catchExceptionHierarchy(ThrowableAssert.ThrowingCallable callable) {
        Throwable throwable = Assertions.catchThrowable((ThrowableAssert.ThrowingCallable)callable);
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        exceptions.add(throwable);
        Throwable cause = throwable;
        do {
            if ((cause = cause.getCause()) == null) continue;
            exceptions.add(cause);
        } while (cause != null);
        return exceptions.iterator();
    }

    protected void failForSqlStatement(String statement) {
        Map statementMappings = this.engineConfig.getDbSqlSessionFactory().getStatementMappings();
        statementMappings.put(statement, "does-not-exist");
    }

    protected String generateString(int size) {
        return new String(new char[size]).replace('\u0000', 'a');
    }
}

