/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.standalone.entity;

import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.eximeebpms.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.eximeebpms.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.eximeebpms.bpm.engine.impl.db.DbEntity;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.TaskEntity;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Test;

public class CaseDefinitionIdUpdateTest
extends PluggableProcessEngineTest {
    @Test
    public void testUpdateCaseDefinitionIdInTask() {
        CaseDefinitionEntity caseDefinitionEntity1 = this.prepareCaseDefinition(UUID.randomUUID().toString());
        CaseDefinitionEntity caseDefinitionEntity2 = this.prepareCaseDefinition(UUID.randomUUID().toString());
        TaskEntity task = new TaskEntity();
        task.setId(UUID.randomUUID().toString());
        task.setCaseDefinitionId(caseDefinitionEntity1.getId());
        this.createTask(task);
        TaskEntity createdTask = this.findTask(task.getId());
        Assertions.assertThat((Object)createdTask).isNotNull();
        task.setCaseDefinitionId(caseDefinitionEntity2.getId());
        this.update((DbEntity)task);
        TaskEntity updatedTask = this.findTask(task.getId());
        Assertions.assertThat((String)updatedTask.getCaseDefinitionId()).isEqualTo((Object)caseDefinitionEntity2.getId());
        this.deleteTask(updatedTask);
        this.deleteCaseDefinition(caseDefinitionEntity1);
        this.deleteCaseDefinition(caseDefinitionEntity2);
    }

    @Test
    public void testUpdateCaseDefinitionIdInCaseExecutionEntity() {
        CaseDefinitionEntity caseDefinitionEntity1 = this.prepareCaseDefinition(UUID.randomUUID().toString());
        CaseDefinitionEntity caseDefinitionEntity2 = this.prepareCaseDefinition(UUID.randomUUID().toString());
        CaseExecutionEntity caseExecutionEntity = this.prepareCaseExecution(caseDefinitionEntity1);
        Assertions.assertThat((String)caseExecutionEntity.getCaseDefinitionId()).isEqualTo((Object)caseDefinitionEntity1.getId());
        this.createCaseExecution(caseExecutionEntity);
        CaseExecutionEntity createdCaseExecution = this.findCaseExecution(caseExecutionEntity.getId());
        Assertions.assertThat((Object)createdCaseExecution).isNotNull();
        createdCaseExecution.setCaseDefinition((CmmnCaseDefinition)caseDefinitionEntity2);
        Assertions.assertThat((String)createdCaseExecution.getCaseDefinitionId()).isEqualTo((Object)caseDefinitionEntity2.getId());
        this.update((DbEntity)createdCaseExecution);
        CaseExecutionEntity updatedCaseExecution = this.findCaseExecution(createdCaseExecution.getId());
        Assertions.assertThat((String)updatedCaseExecution.getCaseDefinitionId()).isEqualTo((Object)caseDefinitionEntity2.getId());
        this.deleteCaseExecution(updatedCaseExecution);
        this.deleteCaseDefinition(caseDefinitionEntity1);
        this.deleteCaseDefinition(caseDefinitionEntity2);
    }

    private CaseExecutionEntity prepareCaseExecution(CaseDefinitionEntity caseDefinitionEntity1) {
        CaseExecutionEntity caseExecutionEntity = new CaseExecutionEntity();
        caseExecutionEntity.setId(UUID.randomUUID().toString());
        caseExecutionEntity.setCaseDefinition((CmmnCaseDefinition)caseDefinitionEntity1);
        return caseExecutionEntity;
    }

    private CaseDefinitionEntity prepareCaseDefinition(String id) {
        CaseDefinitionEntity caseDefinitionEntity = new CaseDefinitionEntity();
        caseDefinitionEntity.setId(id);
        caseDefinitionEntity.setKey(UUID.randomUUID().toString());
        caseDefinitionEntity.setDeploymentId(UUID.randomUUID().toString());
        this.createCaseDefinition(caseDefinitionEntity);
        return caseDefinitionEntity;
    }

    private CaseExecutionEntity findCaseExecution(final String id) {
        return (CaseExecutionEntity)this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute((Command)new Command<CaseExecutionEntity>(){

            public CaseExecutionEntity execute(CommandContext commandContext) {
                return commandContext.getCaseExecutionManager().findCaseExecutionById(id);
            }
        });
    }

    private Void deleteCaseExecution(final CaseExecutionEntity caseExecutionEntity) {
        return (Void)this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getCaseExecutionManager().deleteCaseExecution(caseExecutionEntity);
                return null;
            }
        });
    }

    private void createCaseExecution(final CaseExecutionEntity caseExecutionEntity) {
        this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getCaseExecutionManager().insertCaseExecution(caseExecutionEntity);
                return null;
            }
        });
    }

    private void update(final DbEntity entity) {
        this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getDbEntityManager().merge(entity);
                return null;
            }
        });
    }

    private void createCaseDefinition(final CaseDefinitionEntity caseDefinitionEntity) {
        this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getCaseDefinitionManager().insertCaseDefinition(caseDefinitionEntity);
                return null;
            }
        });
    }

    private Void deleteCaseDefinition(final CaseDefinitionEntity caseDefinitionEntity) {
        return (Void)this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getCaseDefinitionManager().deleteCaseDefinitionsByDeploymentId(caseDefinitionEntity.getDeploymentId());
                return null;
            }
        });
    }

    private void createTask(final TaskEntity taskEntity) {
        this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getTaskManager().insertTask(taskEntity);
                return null;
            }
        });
    }

    private void deleteTask(final TaskEntity taskEntity) {
        this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getTaskManager().delete((DbEntity)taskEntity);
                return null;
            }
        });
    }

    private TaskEntity findTask(final String id) {
        return (TaskEntity)this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute((Command)new Command<TaskEntity>(){

            public TaskEntity execute(CommandContext commandContext) {
                return commandContext.getTaskManager().findTaskById(id);
            }
        });
    }
}

