/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.standalone.history;

import java.util.Arrays;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.history.HistoricVariableInstance;
import org.eximeebpms.bpm.engine.history.HistoricVariableUpdate;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class CustomHistoryTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule("org/eximeebpms/bpm/engine/test/standalone/history/customhistory.eximeebpms.cfg.xml");
    @Rule
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected RuntimeService runtimeService;
    protected HistoryService historyService;

    @Before
    public void setUp() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testReceivesVariableUpdates() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String value = "a Variable Value";
        this.runtimeService.setVariable(instance.getId(), "aStringVariable", (Object)value);
        this.runtimeService.setVariable(instance.getId(), "aBytesVariable", (Object)value.getBytes());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        HistoricVariableInstance historicStringVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("aStringVariable").singleResult();
        Assert.assertNotNull((Object)historicStringVariable);
        Assert.assertEquals((Object)value, (Object)historicStringVariable.getValue());
        HistoricVariableInstance historicBytesVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("aBytesVariable").singleResult();
        Assert.assertNotNull((Object)historicBytesVariable);
        Assert.assertTrue((boolean)Arrays.equals(value.getBytes(), (byte[])historicBytesVariable.getValue()));
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().count());
        HistoricVariableUpdate historicStringVariableUpdate = (HistoricVariableUpdate)this.historyService.createHistoricDetailQuery().variableUpdates().variableInstanceId(historicStringVariable.getId()).singleResult();
        Assert.assertNotNull((Object)historicStringVariableUpdate);
        Assert.assertEquals((Object)value, (Object)historicStringVariableUpdate.getValue());
        HistoricVariableUpdate historicByteVariableUpdate = (HistoricVariableUpdate)this.historyService.createHistoricDetailQuery().variableUpdates().variableInstanceId(historicBytesVariable.getId()).singleResult();
        Assert.assertNotNull((Object)historicByteVariableUpdate);
        Assert.assertTrue((boolean)Arrays.equals(value.getBytes(), (byte[])historicByteVariableUpdate.getValue()));
    }
}

