/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.standalone.history;

import ch.qos.logback.classic.Level;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngineConfiguration;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.commons.testing.ProcessEngineLoggingRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class HistoryCleanupBatchTest {
    protected static final String PROCESS_ENGINE_CONFIG = "org/eximeebpms/bpm/engine/test/standalone/history/eximeebpms.cfg.xml";
    protected static final String CONFIG_LOGGER = "org.eximeebpms.bpm.engine.cfg";
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule().watch(new String[]{"org.eximeebpms.bpm.engine.cfg"}).level(Level.WARN);
    protected ProcessEngine processEngine;
    protected ProcessEngineConfigurationImpl engineConfiguration;

    @Before
    public void setup() {
        this.processEngine = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)PROCESS_ENGINE_CONFIG).buildProcessEngine();
        this.engineConfiguration = (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
    }

    @After
    public void teardown() {
        this.processEngine.close();
    }

    @Test
    public void shouldSetGlobalConfigForBatchHistoryTimeToLive() {
        String batchOperationHistoryTimeToLive = this.engineConfiguration.getBatchOperationHistoryTimeToLive();
        Assertions.assertThat((String)batchOperationHistoryTimeToLive).isEqualTo((Object)"P5D");
    }

    @Test
    public void shouldSetHistoryTimeToLivePerBatchType() {
        Map batchOperationsForHistoryCleanup = this.engineConfiguration.getBatchOperationsForHistoryCleanup();
        Assertions.assertThat((Map)batchOperationsForHistoryCleanup).contains(new Map.Entry[]{Assertions.entry((Object)"instance-migration", (Object)"P10D"), Assertions.entry((Object)"instance-modification", (Object)"P7D"), Assertions.entry((Object)"uknown-operation", (Object)"P3D")});
    }

    @Test
    public void shouldWriteLogWhenBatchTypeIsUnknown() {
        Assertions.assertThat((List)this.loggingRule.getFilteredLog("ENGINE-12010 Invalid batch operation name 'uknown-operation' with history time to live set to'P3D'")).hasSize(1);
    }
}

