/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.standalone.testing;

import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class ProcessEngineRuleJunit4Test {
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();

    @Test
    @Deployment
    public void ruleUsageExample() {
        RuntimeService runtimeService = this.engineRule.getRuntimeService();
        runtimeService.startProcessInstanceByKey("ruleUsage");
        TaskService taskService = this.engineRule.getTaskService();
        Task task = (Task)taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"My Task", (Object)task.getName());
        taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)runtimeService.createProcessInstanceQuery().count());
    }

    @Test
    public void testWithoutDeploymentAnnotation() {
        Assert.assertEquals((Object)"aString", (Object)"aString");
    }

    @Test
    @RequiredHistoryLevel(value="audit")
    public void requiredHistoryLevelAudit() {
        Assertions.assertThat((String)this.currentHistoryLevel()).isIn(new Object[]{"audit", "full"});
    }

    @Test
    @RequiredHistoryLevel(value="activity")
    public void requiredHistoryLevelActivity() {
        Assertions.assertThat((String)this.currentHistoryLevel()).isIn(new Object[]{"activity", "audit", "full"});
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void requiredHistoryLevelFull() {
        Assertions.assertThat((String)this.currentHistoryLevel()).isEqualTo((Object)"full");
    }

    protected String currentHistoryLevel() {
        return this.engineRule.getProcessEngine().getProcessEngineConfiguration().getHistory();
    }
}

