/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.util;

import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.impl.ProcessEngineImpl;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.eximeebpms.bpm.engine.impl.util.ReflectUtil;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class DbSchemaPrefixTestHelper
implements InitializingBean,
DisposableBean {
    private PooledDataSource dataSource;

    public void afterPropertiesSet() throws Exception {
        this.dataSource = new PooledDataSource(ReflectUtil.getClassLoader(), "org.h2.Driver", "jdbc:h2:mem:DatabaseTablePrefixTest;DB_CLOSE_DELAY=1000;", "sa", "");
        Connection connection = this.dataSource.getConnection();
        connection.createStatement().execute("drop schema if exists SCHEMA1 cascade");
        connection.createStatement().execute("create schema SCHEMA1");
        connection.close();
        ProcessEngineConfigurationImpl config1 = DbSchemaPrefixTestHelper.createCustomProcessEngineConfiguration().setProcessEngineName("DatabaseTablePrefixTest-engine1").setDataSource((DataSource)this.dataSource).setDbMetricsReporterActivate(false).setDatabaseSchemaUpdate("NO_CHECK");
        config1.setDatabaseTablePrefix("SCHEMA1.");
        ProcessEngine engine1 = config1.buildProcessEngine();
        connection = this.dataSource.getConnection();
        connection.createStatement().execute("set schema SCHEMA1");
        engine1.getManagementService().databaseSchemaUpgrade(connection, "", "SCHEMA1");
        connection.close();
        engine1.close();
    }

    public void destroy() throws Exception {
        Connection connection = this.dataSource.getConnection();
        connection.createStatement().execute("drop schema if exists SCHEMA1 cascade");
        connection.close();
    }

    private static ProcessEngineConfigurationImpl createCustomProcessEngineConfiguration() {
        return new CustomStandaloneInMemProcessEngineConfiguration().setHistory("full");
    }

    private static class CustomStandaloneInMemProcessEngineConfiguration
    extends StandaloneInMemProcessEngineConfiguration {
        private CustomStandaloneInMemProcessEngineConfiguration() {
        }

        public ProcessEngine buildProcessEngine() {
            this.init();
            return new NoSchemaProcessEngineImpl((ProcessEngineConfigurationImpl)this);
        }

        class NoSchemaProcessEngineImpl
        extends ProcessEngineImpl {
            public NoSchemaProcessEngineImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
                super(processEngineConfiguration);
            }

            protected void executeSchemaOperations() {
            }
        }
    }
}

