/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.util;

import java.util.Stack;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandExecutor;
import org.eximeebpms.bpm.engine.test.util.ExecutionTree;
import org.eximeebpms.bpm.engine.test.util.ExecutionTreeAssertion;
import org.eximeebpms.bpm.engine.test.util.ExecutionTreeProcessDefinitionIdAssertion;
import org.eximeebpms.bpm.engine.test.util.ExecutionTreeStructureAssertion;

public class ExecutionAssert {
    protected ExecutionTree tree;
    protected CommandExecutor commandExecutor;

    public static ExecutionAssert assertThat(ExecutionTree tree) {
        ExecutionAssert assertion = new ExecutionAssert();
        assertion.tree = tree;
        return assertion;
    }

    public ExecutionAssert matches(ExecutionTreeAssertion assertion) {
        assertion.assertExecution(this.tree);
        return this;
    }

    public ExecutionAssert hasProcessDefinitionId(String expectedProcessDefinitionId) {
        ExecutionTreeProcessDefinitionIdAssertion assertion = ExecutionTreeProcessDefinitionIdAssertion.processDefinitionId(expectedProcessDefinitionId);
        this.matches(assertion);
        return this;
    }

    public static ExecutionTreeBuilder describeExecutionTree(String activityId) {
        return new ExecutionTreeBuilder(activityId);
    }

    public static class ExecutionTreeBuilder {
        protected ExecutionTreeStructureAssertion rootAssertion = null;
        protected Stack<ExecutionTreeStructureAssertion> activityInstanceStack = new Stack();

        public ExecutionTreeBuilder(String rootActivityInstanceId) {
            this.rootAssertion = new ExecutionTreeStructureAssertion();
            this.rootAssertion.setExpectedActivityId(rootActivityInstanceId);
            this.activityInstanceStack.push(this.rootAssertion);
        }

        public ExecutionTreeBuilder child(String activityId) {
            ExecutionTreeStructureAssertion newInstance = new ExecutionTreeStructureAssertion();
            newInstance.setExpectedActivityId(activityId);
            ExecutionTreeStructureAssertion parentInstance = this.activityInstanceStack.peek();
            parentInstance.addChildAssertion(newInstance);
            this.activityInstanceStack.push(newInstance);
            return this;
        }

        public ExecutionTreeBuilder scope() {
            ExecutionTreeStructureAssertion currentAssertion = this.activityInstanceStack.peek();
            currentAssertion.setExpectedIsScope(true);
            return this;
        }

        public ExecutionTreeBuilder concurrent() {
            ExecutionTreeStructureAssertion currentAssertion = this.activityInstanceStack.peek();
            currentAssertion.setExpectedIsConcurrent(true);
            return this;
        }

        public ExecutionTreeBuilder eventScope() {
            ExecutionTreeStructureAssertion currentAssertion = this.activityInstanceStack.peek();
            currentAssertion.setExpectedIsEventScope(true);
            return this;
        }

        public ExecutionTreeBuilder noScope() {
            ExecutionTreeStructureAssertion currentAssertion = this.activityInstanceStack.peek();
            currentAssertion.setExpectedIsScope(false);
            return this;
        }

        public ExecutionTreeBuilder id(String id) {
            ExecutionTreeStructureAssertion currentAssertion = this.activityInstanceStack.peek();
            currentAssertion.setExpectedId(id);
            return this;
        }

        public ExecutionTreeBuilder up() {
            this.activityInstanceStack.pop();
            return this;
        }

        public ExecutionTreeStructureAssertion done() {
            return this.rootAssertion;
        }
    }
}

