/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.client.topic.impl.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.eximeebpms.bpm.client.impl.RequestDto;
import org.eximeebpms.bpm.client.task.OrderingConfig;
import org.eximeebpms.bpm.client.task.SortingDto;
import org.eximeebpms.bpm.client.topic.impl.dto.TopicRequestDto;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FetchAndLockRequestDto
extends RequestDto {
    protected int maxTasks;
    protected boolean usePriority;
    protected Long asyncResponseTimeout;
    protected List<TopicRequestDto> topics;
    protected List<SortingDto> sorting;

    public FetchAndLockRequestDto(String workerId, int maxTasks, Long asyncResponseTimeout, List<TopicRequestDto> topics) {
        this(workerId, maxTasks, asyncResponseTimeout, topics, true);
    }

    public FetchAndLockRequestDto(String workerId, int maxTasks, Long asyncResponseTimeout, List<TopicRequestDto> topics, boolean usePriority) {
        this(workerId, maxTasks, asyncResponseTimeout, topics, usePriority, OrderingConfig.empty());
    }

    public FetchAndLockRequestDto(String workerId, int maxTasks, Long asyncResponseTimeout, List<TopicRequestDto> topics, boolean usePriority, OrderingConfig orderingConfig) {
        super(workerId);
        this.maxTasks = maxTasks;
        this.usePriority = usePriority;
        this.asyncResponseTimeout = asyncResponseTimeout;
        this.topics = topics;
        this.sorting = orderingConfig.toSortingDtos();
    }

    public int getMaxTasks() {
        return this.maxTasks;
    }

    public boolean isUsePriority() {
        return this.usePriority;
    }

    public List<TopicRequestDto> getTopics() {
        return this.topics;
    }

    public Long getAsyncResponseTimeout() {
        return this.asyncResponseTimeout;
    }

    public List<SortingDto> getSorting() {
        return this.sorting;
    }

    public void setSorting(List<SortingDto> sorting) {
        this.sorting = sorting;
    }
}

