/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.client.variable.impl;

import java.util.HashMap;
import java.util.Map;
import org.eximeebpms.bpm.client.impl.ExternalTaskClientLogger;
import org.eximeebpms.bpm.client.task.ExternalTask;
import org.eximeebpms.bpm.client.variable.impl.TypedValueField;
import org.eximeebpms.bpm.client.variable.impl.ValueMapper;
import org.eximeebpms.bpm.client.variable.impl.ValueMappers;
import org.eximeebpms.bpm.client.variable.impl.VariableValue;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.eximeebpms.bpm.engine.variable.type.ValueType;
import org.eximeebpms.bpm.engine.variable.value.TypedValue;

public class TypedValues {
    protected static final ExternalTaskClientLogger LOG = ExternalTaskClientLogger.CLIENT_LOGGER;
    protected ValueMappers serializers;

    public TypedValues(ValueMappers serializers) {
        this.serializers = serializers;
    }

    public Map<String, TypedValueField> serializeVariables(Map<String, Object> variables) {
        HashMap<String, TypedValueField> result = new HashMap<String, TypedValueField>();
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                Object variableValue = null;
                variableValue = variables instanceof VariableMap ? ((VariableMap)variables).getValueTyped(variableName) : variables.get(variableName);
                try {
                    TypedValue typedValue = this.createTypedValue(variableValue);
                    TypedValueField typedValueField = this.toTypedValueField(typedValue);
                    result.put(variableName, typedValueField);
                }
                catch (Throwable e) {
                    throw LOG.cannotSerializeVariable(variableName, e);
                }
            }
        }
        return result;
    }

    public Map<String, VariableValue> wrapVariables(ExternalTask externalTask, Map<String, TypedValueField> variables) {
        String executionId = externalTask.getExecutionId();
        HashMap<String, VariableValue> result = new HashMap<String, VariableValue>();
        if (variables != null) {
            variables.forEach((variableName, variableValue) -> {
                Object typeName = variableValue.getType();
                typeName = Character.toLowerCase(((String)typeName).charAt(0)) + ((String)typeName).substring(1);
                variableValue.setType((String)typeName);
                VariableValue value = new VariableValue(executionId, (String)variableName, (TypedValueField)variableValue, this.serializers);
                result.put((String)variableName, value);
            });
        }
        return result;
    }

    protected <T extends TypedValue> TypedValueField toTypedValueField(T typedValue) {
        ValueMapper<T> serializer = this.findSerializer(typedValue);
        if (typedValue instanceof UntypedValueImpl) {
            typedValue = serializer.convertToTypedValue((UntypedValueImpl)typedValue);
        }
        TypedValueField typedValueField = new TypedValueField();
        serializer.writeValue(typedValue, typedValueField);
        ValueType valueType = typedValue.getType();
        typedValueField.setValueInfo(valueType.getValueInfo(typedValue));
        String typeName = valueType.getName();
        String typeNameCapitalized = Character.toUpperCase(typeName.charAt(0)) + typeName.substring(1);
        typedValueField.setType(typeNameCapitalized);
        return typedValueField;
    }

    protected <T extends TypedValue> ValueMapper<T> findSerializer(T typedValue) {
        return this.serializers.findMapperForTypedValue(typedValue);
    }

    protected TypedValue createTypedValue(Object value) {
        TypedValue typedValue = null;
        typedValue = value instanceof TypedValue ? (TypedValue)value : Variables.untypedValue((Object)value);
        return typedValue;
    }
}

