/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.client.variable.impl.format.xml;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.beans.Introspector;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eximeebpms.bpm.client.impl.ExternalTaskClientLogger;
import org.eximeebpms.bpm.client.spi.DataFormat;
import org.eximeebpms.bpm.client.variable.impl.format.xml.DomXmlLogger;
import org.eximeebpms.commons.utils.EnsureUtil;
import org.eximeebpms.commons.utils.IoUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomXmlDataFormat
implements DataFormat {
    protected static final DomXmlLogger LOG = ExternalTaskClientLogger.XML_FORMAT_LOGGER;
    protected String name;
    protected DocumentBuilderFactory documentBuilderFactory;
    protected TransformerFactory transformerFactory;

    public DomXmlDataFormat(String name) {
        this(name, DomXmlDataFormat.defaultDocumentBuilderFactory());
    }

    public DomXmlDataFormat(String name, DocumentBuilderFactory documentBuilderFactory) {
        this(name, documentBuilderFactory, DomXmlDataFormat.defaultTransformerFactory());
    }

    public DomXmlDataFormat(String name, DocumentBuilderFactory documentBuilderFactory, TransformerFactory transformerFactory) {
        this.name = name;
        this.documentBuilderFactory = documentBuilderFactory;
        LOG.usingDocumentBuilderFactory(documentBuilderFactory.getClass().getName());
        this.transformerFactory = transformerFactory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() {
        return this.documentBuilderFactory;
    }

    public TransformerFactory getTransformerFactory() {
        return this.transformerFactory;
    }

    @Override
    public boolean canMap(Object value) {
        return value != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String writeValue(Object value) {
        Element mappedObject = this.writeAsElement(value);
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            StreamResult streamResult = new StreamResult(writer);
            this.writeResult(streamResult, mappedObject);
            String string = writer.toString();
            return string;
        }
        finally {
            IoUtil.closeSilently((Closeable)writer);
        }
    }

    @Override
    public <T> T readValue(String value, String typeIdentifier) {
        EnsureUtil.ensureNotNull((String)"value", (Object)value);
        EnsureUtil.ensureNotNull((String)"typeIdentifier", (Object)typeIdentifier);
        try {
            Class<?> javaClass = DomXmlDataFormat.loadClass(typeIdentifier, this);
            return (T)this.readValue(value, javaClass);
        }
        catch (Exception e) {
            throw LOG.unableToDeserialize(value, typeIdentifier, e);
        }
    }

    @Override
    public <T> T readValue(String value, Class<T> cls) {
        EnsureUtil.ensureNotNull((String)"value", (Object)value);
        EnsureUtil.ensureNotNull((String)"class", cls);
        try {
            Element xmlNode = this.readAsElement(value);
            Unmarshaller unmarshaller = this.createUnmarshaller(cls);
            DOMSource domSource = new DOMSource(xmlNode);
            JAXBElement root = unmarshaller.unmarshal((Source)domSource, cls);
            return (T)root.getValue();
        }
        catch (JAXBException e) {
            throw LOG.unableToDeserialize(value, cls.getCanonicalName(), e);
        }
    }

    @Override
    public String getCanonicalTypeName(Object value) {
        return value.getClass().getName();
    }

    protected void writeResult(StreamResult streamResult, Object input) {
        Node node = (Node)input;
        DOMSource domSource = new DOMSource(node);
        try {
            this.getTransformer().transform(domSource, streamResult);
        }
        catch (TransformerException e) {
            throw LOG.unableToTransformElement(node, e);
        }
    }

    protected Element writeAsElement(Object value) {
        EnsureUtil.ensureNotNull((String)"value", (Object)value);
        Class<?> valueClass = value.getClass();
        DOMResult domResult = new DOMResult();
        try {
            boolean isRootElement;
            Marshaller marshaller = this.createMarshaller(valueClass);
            boolean bl = isRootElement = valueClass.getAnnotation(XmlRootElement.class) != null;
            if (isRootElement) {
                marshaller.marshal(value, (Result)domResult);
            } else {
                String simpleName = Introspector.decapitalize(valueClass.getSimpleName());
                JAXBElement root = new JAXBElement(new QName(simpleName), valueClass, value);
                marshaller.marshal((Object)root, (Result)domResult);
            }
            Node node = domResult.getNode();
            return ((Document)node).getDocumentElement();
        }
        catch (JAXBException e) {
            throw LOG.unableToWriteInput(value, e);
        }
    }

    protected Transformer getTransformer() {
        try {
            Transformer transformer = this.transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            throw LOG.unableToCreateTransformer(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Element readAsElement(String value) {
        Element element;
        DocumentBuilder documentBuilder = this.getDocumentBuilder();
        StringReader stringReader = null;
        BufferedReader bufferedReader = null;
        try {
            stringReader = new StringReader(value);
            bufferedReader = new BufferedReader(stringReader);
            InputSource inputSource = new InputSource(bufferedReader);
            LOG.parsingInput();
            Document document = documentBuilder.parse(inputSource);
            element = document.getDocumentElement();
        }
        catch (SAXException e) {
            try {
                throw LOG.unableToParseInput(e);
                catch (IOException e2) {
                    throw LOG.unableToParseInput(e2);
                }
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(bufferedReader);
                IoUtil.closeSilently((Closeable)stringReader);
                throw throwable;
            }
        }
        IoUtil.closeSilently((Closeable)bufferedReader);
        IoUtil.closeSilently((Closeable)stringReader);
        return element;
    }

    protected DocumentBuilder getDocumentBuilder() {
        try {
            DocumentBuilder docBuilder = this.documentBuilderFactory.newDocumentBuilder();
            LOG.createdDocumentBuilder();
            return docBuilder;
        }
        catch (ParserConfigurationException e) {
            throw LOG.unableToCreateParser(e);
        }
    }

    protected JAXBContext getContext(Class<?> ... types) {
        try {
            return JAXBContext.newInstance((Class[])types);
        }
        catch (JAXBException e) {
            throw LOG.unableToCreateContext(e);
        }
    }

    protected Marshaller createMarshaller(Class<?> ... types) {
        try {
            return this.getContext(types).createMarshaller();
        }
        catch (JAXBException e) {
            throw LOG.unableToCreateMarshaller(e);
        }
    }

    protected Unmarshaller createUnmarshaller(Class<?> ... types) {
        try {
            return this.getContext(types).createUnmarshaller();
        }
        catch (JAXBException e) {
            throw LOG.unableToCreateUnmarshaller(e);
        }
    }

    public static TransformerFactory defaultTransformerFactory() {
        return TransformerFactory.newInstance();
    }

    public static DocumentBuilderFactory defaultDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        LOG.documentBuilderFactoryConfiguration("namespaceAware", "true");
        documentBuilderFactory.setValidating(false);
        LOG.documentBuilderFactoryConfiguration("validating", "false");
        documentBuilderFactory.setIgnoringComments(true);
        LOG.documentBuilderFactoryConfiguration("ignoringComments", "true");
        documentBuilderFactory.setIgnoringElementContentWhitespace(false);
        LOG.documentBuilderFactoryConfiguration("ignoringElementContentWhitespace", "false");
        return documentBuilderFactory;
    }

    public static Class<?> loadClass(String classname, DataFormat dataFormat) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            try {
                return cl.loadClass(classname);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        cl = dataFormat.getClass().getClassLoader();
        try {
            return cl.loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            throw LOG.classNotFound(classname, e);
        }
    }
}

