/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.client.variable.impl.mapper;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eximeebpms.bpm.client.impl.ExternalTaskClientLogger;
import org.eximeebpms.bpm.client.variable.impl.TypedValueField;
import org.eximeebpms.bpm.client.variable.impl.mapper.PrimitiveValueMapper;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.eximeebpms.bpm.engine.variable.type.ValueType;
import org.eximeebpms.bpm.engine.variable.value.DateValue;

public class DateValueMapper
extends PrimitiveValueMapper<DateValue> {
    protected static final ExternalTaskClientLogger LOG = ExternalTaskClientLogger.CLIENT_LOGGER;
    protected String dateFormat;

    public DateValueMapper(String dateFormat) {
        super(ValueType.DATE);
        this.dateFormat = dateFormat;
    }

    @Override
    public DateValue convertToTypedValue(UntypedValueImpl untypedValue) {
        return Variables.dateValue((Date)((Date)untypedValue.getValue()));
    }

    @Override
    public DateValue readValue(TypedValueField typedValueField) {
        Date date = null;
        String value = (String)typedValueField.getValue();
        if (value != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat);
            try {
                date = sdf.parse(value);
            }
            catch (ParseException e) {
                throw LOG.valueMapperExceptionWhileParsingDate(value, e);
            }
        }
        return Variables.dateValue(date);
    }

    @Override
    public void writeValue(DateValue dateValue, TypedValueField typedValueField) {
        Date date = (Date)dateValue.getValue();
        if (date != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat);
            typedValueField.setValue(sdf.format(date));
        }
    }

    @Override
    protected boolean canReadValue(TypedValueField typedValueField) {
        Object value = typedValueField.getValue();
        return value == null || value instanceof String;
    }
}

