/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.client.variable.impl.mapper;

import java.io.InputStream;
import org.apache.hc.client5.http.utils.Base64;
import org.eximeebpms.bpm.client.variable.impl.TypedValueField;
import org.eximeebpms.bpm.client.variable.impl.mapper.PrimitiveValueMapper;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.eximeebpms.bpm.engine.variable.type.ValueType;
import org.eximeebpms.bpm.engine.variable.value.BytesValue;
import org.eximeebpms.bpm.engine.variable.value.TypedValue;
import org.eximeebpms.commons.utils.IoUtil;

public class ByteArrayValueMapper
extends PrimitiveValueMapper<BytesValue> {
    public ByteArrayValueMapper() {
        super(ValueType.BYTES);
    }

    @Override
    public BytesValue convertToTypedValue(UntypedValueImpl untypedValue) {
        Object value = untypedValue.getValue();
        byte[] byteArr = value instanceof byte[] ? (byte[])value : IoUtil.inputStreamAsByteArray((InputStream)((InputStream)value));
        return Variables.byteArrayValue((byte[])byteArr);
    }

    @Override
    public BytesValue readValue(TypedValueField typedValueField) {
        byte[] byteArr = null;
        String value = (String)typedValueField.getValue();
        if (value != null) {
            byteArr = Base64.decodeBase64((String)value);
        }
        return Variables.byteArrayValue(byteArr);
    }

    @Override
    public void writeValue(BytesValue byteValue, TypedValueField typedValueField) {
        byte[] bytes = (byte[])byteValue.getValue();
        if (bytes != null) {
            typedValueField.setValue(Base64.encodeBase64String((byte[])bytes));
        }
    }

    @Override
    protected boolean canWriteValue(TypedValue typedValue) {
        Object value = typedValue.getValue();
        return super.canWriteValue(typedValue) || value instanceof InputStream;
    }

    @Override
    protected boolean canReadValue(TypedValueField typedValueField) {
        Object value = typedValueField.getValue();
        return value == null || value instanceof String;
    }
}

