/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.client.variable.impl.mapper;

import java.util.Map;
import org.eximeebpms.bpm.client.impl.ExternalTaskClientLogger;
import org.eximeebpms.bpm.client.spi.DataFormat;
import org.eximeebpms.bpm.client.variable.impl.AbstractTypedValueMapper;
import org.eximeebpms.bpm.client.variable.impl.TypedValueField;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.engine.variable.impl.value.ObjectValueImpl;
import org.eximeebpms.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.eximeebpms.bpm.engine.variable.type.ValueType;
import org.eximeebpms.bpm.engine.variable.value.ObjectValue;
import org.eximeebpms.bpm.engine.variable.value.SerializableValue;
import org.eximeebpms.bpm.engine.variable.value.TypedValue;

public class ObjectValueMapper
extends AbstractTypedValueMapper<ObjectValue> {
    protected static final ExternalTaskClientLogger LOG = ExternalTaskClientLogger.CLIENT_LOGGER;
    protected DataFormat dataFormat;
    protected String serializationDataFormat;

    public ObjectValueMapper(String serializationDataFormat, DataFormat dataFormat) {
        super((ValueType)ValueType.OBJECT);
        this.serializationDataFormat = serializationDataFormat;
        this.dataFormat = dataFormat;
    }

    @Override
    public String getSerializationDataformat() {
        return this.serializationDataFormat;
    }

    @Override
    public void writeValue(ObjectValue typedValue, TypedValueField typedValueField) {
        Object objectToSerialize;
        String serializedStringValue = typedValue.getValueSerialized();
        if (typedValue.isDeserialized() && (objectToSerialize = typedValue.getValue()) != null) {
            try {
                serializedStringValue = this.dataFormat.writeValue(objectToSerialize);
            }
            catch (Exception e) {
                throw LOG.valueMapperExceptionWhileSerializingObject(e);
            }
        }
        this.writeSerializedValue(typedValueField, serializedStringValue);
        this.updateTypedValue(typedValue, serializedStringValue);
    }

    @Override
    public ObjectValue readValue(TypedValueField value, boolean deserializeObjectValue) {
        String serializedStringValue = (String)value.getValue();
        if (deserializeObjectValue) {
            Object deserializedObject = null;
            if (serializedStringValue != null) {
                try {
                    String objectTypeName = this.readObjectNameFromFields(value);
                    deserializedObject = this.dataFormat.readValue(serializedStringValue, objectTypeName);
                }
                catch (Exception e) {
                    throw LOG.valueMapperExceptionWhileDeserializingObject(e);
                }
            }
            return this.createDeserializedValue(deserializedObject, serializedStringValue, value);
        }
        return this.createSerializedValue(serializedStringValue, value);
    }

    @Override
    public ObjectValue convertToTypedValue(UntypedValueImpl untypedValue) {
        return (ObjectValue)Variables.objectValue((Object)untypedValue.getValue()).create();
    }

    protected void writeSerializedValue(TypedValueField typedValueField, String serializedValue) {
        typedValueField.setValue(serializedValue);
    }

    protected void updateTypedValue(ObjectValue value, String serializedValue) {
        String objectTypeName = this.getObjectTypeName(value);
        ObjectValueImpl objectValue = (ObjectValueImpl)value;
        objectValue.setObjectTypeName(objectTypeName);
        objectValue.setSerializedValue(serializedValue);
        objectValue.setSerializationDataFormat(this.serializationDataFormat);
    }

    protected String getObjectTypeName(ObjectValue value) {
        String objectTypeName = value.getObjectTypeName();
        if (objectTypeName == null && !value.isDeserialized() && value.getValueSerialized() != null) {
            throw LOG.valueMapperExceptionDueToNoObjectTypeName();
        }
        if (value.isDeserialized() && value.getValue() != null) {
            objectTypeName = this.dataFormat.getCanonicalTypeName(value.getValue());
        }
        return objectTypeName;
    }

    @Override
    protected boolean canWriteValue(TypedValue typedValue) {
        if (!(typedValue instanceof SerializableValue) && !(typedValue instanceof UntypedValueImpl)) {
            return false;
        }
        if (typedValue instanceof SerializableValue) {
            SerializableValue serializableValue = (SerializableValue)typedValue;
            String requestedDataFormat = serializableValue.getSerializationDataFormat();
            if (!serializableValue.isDeserialized()) {
                return this.serializationDataFormat.equals(requestedDataFormat);
            }
            boolean canSerialize = typedValue.getValue() == null || this.dataFormat.canMap(typedValue.getValue());
            return canSerialize && (requestedDataFormat == null || this.serializationDataFormat.equals(requestedDataFormat));
        }
        return typedValue.getValue() == null || this.dataFormat.canMap(typedValue.getValue());
    }

    @Override
    protected boolean canReadValue(TypedValueField typedValueField) {
        Map<String, Object> valueInfo = typedValueField.getValueInfo();
        String serializationDataformat = (String)valueInfo.get("serializationDataFormat");
        Object value = typedValueField.getValue();
        return (value == null || value instanceof String) && this.getSerializationDataformat().equals(serializationDataformat);
    }

    protected ObjectValue createDeserializedValue(Object deserializedObject, String serializedValue, TypedValueField typedValueField) {
        String objectTypeName = this.readObjectNameFromFields(typedValueField);
        return new ObjectValueImpl(deserializedObject, serializedValue, this.serializationDataFormat, objectTypeName, true);
    }

    protected ObjectValue createSerializedValue(String serializedValue, TypedValueField typedValueField) {
        String objectTypeName = this.readObjectNameFromFields(typedValueField);
        return new ObjectValueImpl(null, serializedValue, this.serializationDataFormat, objectTypeName, false);
    }

    protected String readObjectNameFromFields(TypedValueField typedValueField) {
        Map<String, Object> valueInfo = typedValueField.getValueInfo();
        return (String)valueInfo.get("objectTypeName");
    }
}

