/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.qa.impl;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eximeebpms.bpm.BpmPlatform;
import org.eximeebpms.bpm.application.ProcessApplicationInterface;
import org.eximeebpms.bpm.container.impl.plugin.BpmPlatformPlugin;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.impl.ManagementServiceImpl;
import org.eximeebpms.bpm.engine.impl.management.DatabasePurgeReport;
import org.eximeebpms.bpm.engine.impl.management.PurgeReport;
import org.eximeebpms.bpm.engine.impl.persistence.deploy.cache.CachePurgeReport;

public class EnsureCleanDbPlugin
implements BpmPlatformPlugin {
    protected static final String DATABASE_NOT_CLEAN = "Database was not clean!\n";
    protected static final String CACHE_IS_NOT_CLEAN = "Cache was not clean!\n";
    protected Logger logger = Logger.getLogger(EnsureCleanDbPlugin.class.getName());
    private AtomicInteger counter = new AtomicInteger();

    public void postProcessApplicationDeploy(ProcessApplicationInterface processApplication) {
        this.counter.incrementAndGet();
    }

    public void postProcessApplicationUndeploy(ProcessApplicationInterface processApplication) {
        if (this.counter.get() == 0 || this.counter.decrementAndGet() == 0) {
            ProcessEngine defaultProcessEngine = BpmPlatform.getDefaultProcessEngine();
            try {
                this.logger.log(Level.INFO, "=== Ensure Clean Database ===");
                ManagementServiceImpl managementService = (ManagementServiceImpl)defaultProcessEngine.getManagementService();
                PurgeReport report = managementService.purge();
                if (report.isEmpty()) {
                    this.logger.log(Level.INFO, "Clean DB and cache.");
                } else {
                    CachePurgeReport cachePurgeReport;
                    StringBuilder builder = new StringBuilder();
                    DatabasePurgeReport databasePurgeReport = report.getDatabasePurgeReport();
                    if (!databasePurgeReport.isEmpty()) {
                        builder.append(DATABASE_NOT_CLEAN).append(databasePurgeReport.getPurgeReportAsString());
                    }
                    if (!(cachePurgeReport = report.getCachePurgeReport()).isEmpty()) {
                        builder.append(CACHE_IS_NOT_CLEAN).append(cachePurgeReport.getPurgeReportAsString());
                    }
                    this.logger.log(Level.INFO, builder.toString());
                }
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, "Could not clean DB:", e);
            }
        }
    }
}

