/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.qa.upgrade;

import java.util.Map;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.qa.upgrade.ScenarioSetup;

public class Scenario {
    protected int times = 1;
    protected String name;
    protected String extendedScenario;
    protected ScenarioSetup setup;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getTimes() {
        return this.times;
    }

    public void setTimes(int times) {
        this.times = times;
    }

    public String getExtendedScenario() {
        return this.extendedScenario;
    }

    public void setExtendedScenario(String extendedScenario) {
        this.extendedScenario = extendedScenario;
    }

    public void setSetup(ScenarioSetup setup) {
        this.setup = setup;
    }

    public Scenario perform(ScenarioSetup setup) {
        this.setup = setup;
        return this;
    }

    public void createInstances(ProcessEngine engine, Map<String, Scenario> scenarios) {
        for (int i = 1; i <= this.times; ++i) {
            String scenarioInstanceName = this.name + "." + i;
            this.create(engine, scenarios, scenarioInstanceName);
        }
    }

    public void create(ProcessEngine engine, Map<String, Scenario> scenarios, String scenarioInstanceName) {
        if (this.extendedScenario != null) {
            if (scenarios.containsKey(this.extendedScenario)) {
                Scenario parentScenario = scenarios.get(this.extendedScenario);
                parentScenario.create(engine, scenarios, scenarioInstanceName);
            } else {
                throw new ProcessEngineException("Extended scenario " + this.extendedScenario + " not registered");
            }
        }
        if (this.setup != null) {
            this.setup.execute(engine, scenarioInstanceName);
        }
    }
}

