/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.qa.upgrade;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.qa.upgrade.DescribesScenario;
import org.eximeebpms.bpm.qa.upgrade.ExtendsScenario;
import org.eximeebpms.bpm.qa.upgrade.Scenario;
import org.eximeebpms.bpm.qa.upgrade.ScenarioSetup;
import org.eximeebpms.bpm.qa.upgrade.Times;

public class ScenarioRunner {
    protected ProcessEngine engine;
    protected String engineVersion;

    public ScenarioRunner(ProcessEngine engine, String engineVersion) {
        this.engine = engine;
        this.engineVersion = engineVersion;
    }

    public void setupScenarios(Class<?> clazz) {
        this.performDeployments(clazz);
        this.executeScenarioSetups(clazz);
    }

    protected void performDeployments(Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            Deployment deploymentAnnotation = method.getAnnotation(Deployment.class);
            if (deploymentAnnotation == null) continue;
            Object deploymentResource = null;
            try {
                deploymentResource = method.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not invoke method " + clazz.getName() + "#" + method.getName() + " specifying a deployment", e);
            }
            if (String.class.isAssignableFrom(method.getReturnType())) {
                String deploymentResourcePath = (String)deploymentResource;
                this.engine.getRepositoryService().createDeployment().name(clazz.getSimpleName() + "." + method.getName()).addClasspathResource(deploymentResourcePath).deploy();
                continue;
            }
            if (!BpmnModelInstance.class.isAssignableFrom(method.getReturnType()) || deploymentResource == null) continue;
            BpmnModelInstance instance = (BpmnModelInstance)deploymentResource;
            this.engine.getRepositoryService().createDeployment().addModelInstance(clazz.getSimpleName() + "." + method.getName() + ".bpmn20.xml", instance).deploy();
        }
    }

    protected void executeScenarioSetups(Class<?> clazz) {
        HashMap<String, Scenario> scenarios = new HashMap<String, Scenario>();
        for (Method method : clazz.getDeclaredMethods()) {
            DescribesScenario scenarioAnnotation = method.getAnnotation(DescribesScenario.class);
            if (scenarioAnnotation == null) continue;
            Scenario scenario = new Scenario();
            scenario.setName(this.createScenarioName(clazz, scenarioAnnotation.value()));
            ExtendsScenario extendedScenarioAnnotation = method.getAnnotation(ExtendsScenario.class);
            if (extendedScenarioAnnotation != null) {
                scenario.setExtendedScenario(this.createScenarioName(clazz, extendedScenarioAnnotation.value()));
            }
            try {
                ScenarioSetup setup = (ScenarioSetup)method.invoke(null, new Object[0]);
                scenario.setSetup(setup);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not invoke method " + clazz.getName() + "#" + method.getName() + " specifying scenarios " + scenario.getName(), e);
            }
            Times timesAnnotation = method.getAnnotation(Times.class);
            if (timesAnnotation != null) {
                scenario.setTimes(timesAnnotation.value());
            }
            scenarios.put(scenario.getName(), scenario);
        }
        for (Scenario scenario : scenarios.values()) {
            this.setupScenario(scenarios, scenario);
        }
    }

    protected String createScenarioName(Class<?> declaringClass, String name) {
        StringBuilder sb = new StringBuilder();
        if (this.engineVersion != null) {
            sb.append(this.engineVersion);
            sb.append(".");
        }
        sb.append(declaringClass.getSimpleName());
        sb.append(".");
        sb.append(name);
        return sb.toString();
    }

    protected void setupScenario(Map<String, Scenario> scenarios, Scenario scenario) {
        scenario.createInstances(this.engine, scenarios);
    }
}

