/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.qa.upgrade;

import org.eximeebpms.bpm.engine.history.HistoricIncidentQuery;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstance;
import org.eximeebpms.bpm.engine.management.JobDefinitionQuery;
import org.eximeebpms.bpm.engine.runtime.CaseExecutionQuery;
import org.eximeebpms.bpm.engine.runtime.CaseInstance;
import org.eximeebpms.bpm.engine.runtime.CaseInstanceQuery;
import org.eximeebpms.bpm.engine.runtime.ExecutionQuery;
import org.eximeebpms.bpm.engine.runtime.IncidentQuery;
import org.eximeebpms.bpm.engine.runtime.JobQuery;
import org.eximeebpms.bpm.engine.runtime.MessageCorrelationBuilder;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceQuery;
import org.eximeebpms.bpm.engine.task.TaskQuery;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.qa.upgrade.Origin;
import org.eximeebpms.bpm.qa.upgrade.ScenarioUnderTest;
import org.junit.Assert;
import org.junit.runner.Description;

public class UpgradeTestRule
extends ProcessEngineRule {
    protected String scenarioTestedByClass = null;
    protected String scenarioName;
    protected String tag;

    public UpgradeTestRule() {
        super("eximeebpms.cfg.xml");
    }

    public UpgradeTestRule(String configurationResource) {
        super(configurationResource);
    }

    public void starting(Description description) {
        Origin originAnnotation;
        ScenarioUnderTest testScenarioAnnotation;
        ScenarioUnderTest testScenarioClassAnnotation;
        Class testClass = description.getTestClass();
        if (this.scenarioTestedByClass == null && (testScenarioClassAnnotation = testClass.getAnnotation(ScenarioUnderTest.class)) != null) {
            this.scenarioTestedByClass = testScenarioClassAnnotation.value();
        }
        if ((testScenarioAnnotation = (ScenarioUnderTest)description.getAnnotation(ScenarioUnderTest.class)) != null) {
            this.scenarioName = this.scenarioTestedByClass != null ? this.scenarioTestedByClass + "." + testScenarioAnnotation.value() : testScenarioAnnotation.value();
        }
        if ((originAnnotation = (Origin)description.getAnnotation(Origin.class)) == null) {
            originAnnotation = testClass.getAnnotation(Origin.class);
        }
        if (originAnnotation != null) {
            this.tag = originAnnotation.value();
        }
        if (this.scenarioName == null) {
            throw new RuntimeException("Could not determine scenario under test for test " + description.getDisplayName());
        }
        super.starting(description);
    }

    public TaskQuery taskQuery() {
        return this.taskService.createTaskQuery().processInstanceBusinessKey(this.getBuisnessKey());
    }

    public ExecutionQuery executionQuery() {
        return this.runtimeService.createExecutionQuery().processInstanceBusinessKey(this.getBuisnessKey());
    }

    public JobQuery jobQuery() {
        ProcessInstance instance = this.processInstance();
        return this.managementService.createJobQuery().processInstanceId(instance.getId());
    }

    public JobDefinitionQuery jobDefinitionQuery() {
        ProcessInstance instance = this.processInstance();
        return this.managementService.createJobDefinitionQuery().processDefinitionId(instance.getProcessDefinitionId());
    }

    public IncidentQuery incidentQuery() {
        ProcessInstance processInstance = this.processInstance();
        return this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId());
    }

    public ProcessInstanceQuery processInstanceQuery() {
        return this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(this.getBuisnessKey());
    }

    public ProcessInstance processInstance() {
        ProcessInstance instance = (ProcessInstance)this.processInstanceQuery().singleResult();
        if (instance == null) {
            throw new RuntimeException("There is no process instance for scenario " + this.getBuisnessKey());
        }
        return instance;
    }

    public HistoricProcessInstance historicProcessInstance() {
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(this.getBuisnessKey()).singleResult();
        if (historicProcessInstance == null) {
            throw new RuntimeException("There is no historic process instance for scenario " + this.getBuisnessKey());
        }
        return historicProcessInstance;
    }

    public HistoricIncidentQuery historicIncidentQuery() {
        ProcessInstance processInstance = this.processInstance();
        return this.historyService.createHistoricIncidentQuery().processInstanceId(processInstance.getId());
    }

    public MessageCorrelationBuilder messageCorrelation(String messageName) {
        return this.runtimeService.createMessageCorrelation(messageName).processInstanceBusinessKey(this.getBuisnessKey());
    }

    public void assertScenarioEnded() {
        Assert.assertTrue((String)("Process instance for scenario " + this.getBuisnessKey() + " should have ended"), (this.processInstanceQuery().singleResult() == null ? 1 : 0) != 0);
    }

    public CaseInstanceQuery caseInstanceQuery() {
        return this.caseService.createCaseInstanceQuery().caseInstanceBusinessKey(this.getBuisnessKey());
    }

    public CaseExecutionQuery caseExecutionQuery() {
        return this.caseService.createCaseExecutionQuery().caseInstanceBusinessKey(this.getBuisnessKey());
    }

    public CaseInstance caseInstance() {
        CaseInstance instance = (CaseInstance)this.caseInstanceQuery().singleResult();
        if (instance == null) {
            throw new RuntimeException("There is no case instance for scenario " + this.getBuisnessKey());
        }
        return instance;
    }

    public String getScenarioName() {
        return this.scenarioName;
    }

    public String getBuisnessKey() {
        if (this.tag != null) {
            return this.tag + "." + this.scenarioName;
        }
        return this.scenarioName;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }
}

