/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.qa.upgrade.util;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eximeebpms.bpm.qa.upgrade.util.ExpectedTransitionInstance;

public class ExpectedActivityInstance {
    protected List<String> activityIds = new ArrayList<String>();
    protected List<ExpectedActivityInstance> childActivityInstances = new ArrayList<ExpectedActivityInstance>();
    protected List<ExpectedTransitionInstance> childTransitionInstances = new ArrayList<ExpectedTransitionInstance>();

    public List<String> getActivityIds() {
        return this.activityIds;
    }

    public void setActivityIds(List<String> activityIds) {
        this.activityIds = activityIds;
    }

    public void setActivityIds(String[] activityIds) {
        this.activityIds = Arrays.asList(activityIds);
    }

    public void setActivityId(String activityId) {
        this.activityIds = Arrays.asList(activityId);
    }

    public List<ExpectedActivityInstance> getChildActivityInstances() {
        return this.childActivityInstances;
    }

    public void setChildActivityInstances(List<ExpectedActivityInstance> childInstances) {
        this.childActivityInstances = childInstances;
    }

    public List<ExpectedTransitionInstance> getChildTransitionInstances() {
        return this.childTransitionInstances;
    }

    public void setChildTransitionInstances(List<ExpectedTransitionInstance> childTransitionInstances) {
        this.childTransitionInstances = childTransitionInstances;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        this.writeTree(writer, "", true);
        return writer.toString();
    }

    protected void writeTree(StringWriter writer, String prefix, boolean isTail) {
        int i;
        writer.append(prefix);
        if (isTail) {
            writer.append("\u2514\u2500\u2500 ");
        } else {
            writer.append("\u251c\u2500\u2500 ");
        }
        writer.append(String.valueOf(this.getActivityIds()) + "\n");
        for (i = 0; i < this.childTransitionInstances.size(); ++i) {
            ExpectedTransitionInstance transitionInstance = this.childTransitionInstances.get(i);
            boolean transitionIsTail = i == this.childTransitionInstances.size() - 1 && this.childActivityInstances.size() == 0;
            this.writeTransition(transitionInstance, writer, prefix + (isTail ? "    " : "\u2502   "), transitionIsTail);
        }
        for (i = 0; i < this.childActivityInstances.size(); ++i) {
            ExpectedActivityInstance child = this.childActivityInstances.get(i);
            child.writeTree(writer, prefix + (isTail ? "    " : "\u2502   "), i == this.childActivityInstances.size() - 1);
        }
    }

    protected void writeTransition(ExpectedTransitionInstance transition, StringWriter writer, String prefix, boolean isTail) {
        writer.append(prefix);
        if (isTail) {
            writer.append("\u2514\u2500\u2500 ");
        } else {
            writer.append("\u251c\u2500\u2500 ");
        }
        writer.append("transition to/from " + transition.getActivityId() + "\n");
    }
}

