/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.run;

import java.util.List;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEnginePlugin;
import org.eximeebpms.bpm.engine.impl.plugin.AdministratorAuthorizationPlugin;
import org.eximeebpms.bpm.identity.impl.ldap.plugin.LdapIdentityProviderPlugin;
import org.eximeebpms.bpm.run.CamundaBpmRunDeploymentConfiguration;
import org.eximeebpms.bpm.run.CamundaBpmRunProcessEngineConfiguration;
import org.eximeebpms.bpm.run.property.CamundaBpmRunProperties;
import org.eximeebpms.bpm.spring.boot.starter.CamundaBpmAutoConfiguration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableConfigurationProperties(value={CamundaBpmRunProperties.class})
@Configuration
@AutoConfigureAfter(value={CamundaBpmAutoConfiguration.class})
public class CamundaBpmRunConfiguration {
    @Bean
    @ConditionalOnProperty(name={"enabled"}, havingValue="true", prefix="eximeebpms.bpm.run.ldap")
    public LdapIdentityProviderPlugin ldapIdentityProviderPlugin(CamundaBpmRunProperties properties) {
        return properties.getLdap();
    }

    @Bean
    @ConditionalOnProperty(name={"enabled"}, havingValue="true", prefix="eximeebpms.bpm.run.admin-auth")
    public AdministratorAuthorizationPlugin administratorAuthorizationPlugin(CamundaBpmRunProperties properties) {
        return properties.getAdminAuth();
    }

    @Bean
    public ProcessEngineConfigurationImpl processEngineConfigurationImpl(List<ProcessEnginePlugin> processEnginePluginsFromContext, CamundaBpmRunProperties properties, CamundaBpmRunDeploymentConfiguration deploymentConfig) {
        String normalizedDeploymentDir = deploymentConfig.getNormalizedDeploymentDir();
        boolean deployChangedOnly = properties.getDeployment().isDeployChangedOnly();
        List processEnginePluginsFromYaml = properties.getProcessEnginePlugins();
        return new CamundaBpmRunProcessEngineConfiguration(normalizedDeploymentDir, deployChangedOnly, processEnginePluginsFromContext, processEnginePluginsFromYaml);
    }

    @Bean
    public CamundaBpmRunDeploymentConfiguration camundaDeploymentConfiguration(@Value(value="${eximeebpms.deploymentDir:#{null}}") String deploymentDir) {
        return new CamundaBpmRunDeploymentConfiguration(deploymentDir);
    }
}

