/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.run;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.impl.cfg.CompositeProcessEnginePlugin;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEnginePlugin;
import org.eximeebpms.bpm.engine.spring.SpringProcessEngineConfiguration;
import org.eximeebpms.bpm.run.property.CamundaBpmRunProcessEnginePluginProperty;
import org.eximeebpms.bpm.run.utils.CamundaBpmRunProcessEnginePluginHelper;
import org.springframework.core.io.Resource;

public class CamundaBpmRunProcessEngineConfiguration
extends SpringProcessEngineConfiguration {
    private final String normalizedDeploymentDir;

    public CamundaBpmRunProcessEngineConfiguration(String normalizedDeploymentDir, boolean deployChangedOnly, List<ProcessEnginePlugin> processEnginePluginsFromContext, List<CamundaBpmRunProcessEnginePluginProperty> processEnginePluginsFromYaml) {
        this.normalizedDeploymentDir = normalizedDeploymentDir;
        this.setDeployChangedOnly(deployChangedOnly);
        this.configureProcessEnginePlugins(processEnginePluginsFromContext, processEnginePluginsFromYaml);
    }

    protected String getFileResourceName(Resource resource) {
        try {
            String resourceAbsolutePath = resource.getURI().toString();
            int startIndex = resourceAbsolutePath.indexOf(this.normalizedDeploymentDir) + this.normalizedDeploymentDir.length();
            return resourceAbsolutePath.substring(startIndex);
        }
        catch (IOException e) {
            throw new ProcessEngineException("Failed to locate resource " + resource.getFilename(), (Throwable)e);
        }
    }

    protected void initTelemetryData() {
        super.initTelemetryData();
        Set camundaIntegration = this.telemetryData.getProduct().getInternals().getCamundaIntegration();
        camundaIntegration.add("eximeebpms-bpm-run");
    }

    protected void configureProcessEnginePlugins(List<ProcessEnginePlugin> processEnginePluginsFromContext, List<CamundaBpmRunProcessEnginePluginProperty> processEnginePluginsFromYaml) {
        CamundaBpmRunProcessEnginePluginHelper.registerYamlPlugins(processEnginePluginsFromContext, processEnginePluginsFromYaml);
        this.processEnginePlugins.add(new CompositeProcessEnginePlugin(processEnginePluginsFromContext));
    }
}

