/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.run;

import jakarta.servlet.Filter;
import java.util.Collections;
import org.apache.catalina.filters.CorsFilter;
import org.eximeebpms.bpm.engine.rest.security.auth.ProcessEngineAuthenticationFilter;
import org.eximeebpms.bpm.run.property.CamundaBpmRunAuthenticationProperties;
import org.eximeebpms.bpm.run.property.CamundaBpmRunProperties;
import org.eximeebpms.bpm.spring.boot.starter.CamundaBpmAutoConfiguration;
import org.eximeebpms.bpm.spring.boot.starter.rest.CamundaBpmRestInitializer;
import org.eximeebpms.bpm.spring.boot.starter.rest.CamundaJerseyResourceConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.servlet.JerseyApplicationPath;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableConfigurationProperties(value={CamundaBpmRunProperties.class})
@Configuration
@AutoConfigureAfter(value={CamundaBpmAutoConfiguration.class})
@ConditionalOnClass(value={CamundaBpmRestInitializer.class})
public class CamundaBpmRunRestConfiguration {
    @Autowired
    CamundaBpmRunProperties camundaBpmRunProperties;
    private static int CORS_FILTER_PRECEDENCE = 0;
    private static int AUTH_FILTER_PRECEDENCE = 1;

    @Bean
    @ConditionalOnProperty(name={"enabled"}, havingValue="true", prefix="eximeebpms.bpm.run.auth")
    public FilterRegistrationBean<Filter> processEngineAuthenticationFilter(JerseyApplicationPath applicationPath) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setName("eximeebpms-auth");
        registration.setFilter((Filter)new ProcessEngineAuthenticationFilter());
        registration.setOrder(AUTH_FILTER_PRECEDENCE);
        String restApiPathPattern = applicationPath.getUrlMapping();
        registration.addUrlPatterns(new String[]{restApiPathPattern});
        CamundaBpmRunAuthenticationProperties properties = this.camundaBpmRunProperties.getAuth();
        if (properties.getAuthentication() == null || "basic".equals(properties.getAuthentication())) {
            registration.addInitParameter("authentication-provider", "org.eximeebpms.bpm.engine.rest.security.auth.impl.HttpBasicAuthenticationProvider");
        }
        return registration;
    }

    @Bean
    @ConditionalOnProperty(name={"enabled"}, havingValue="true", prefix="eximeebpms.bpm.run.cors")
    public FilterRegistrationBean<Filter> corsFilter(JerseyApplicationPath applicationPath) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setName("eximeebpms-cors");
        CorsFilter corsFilter = new CorsFilter();
        registration.setFilter((Filter)corsFilter);
        registration.setOrder(CORS_FILTER_PRECEDENCE);
        String restApiPathPattern = applicationPath.getUrlMapping();
        registration.addUrlPatterns(new String[]{restApiPathPattern});
        registration.addInitParameter("cors.allowed.origins", this.camundaBpmRunProperties.getCors().getAllowedOrigins());
        registration.addInitParameter("cors.allowed.methods", "GET,POST,HEAD,OPTIONS,PUT,DELETE");
        registration.addInitParameter("cors.allowed.headers", this.camundaBpmRunProperties.getCors().getAllowedHeaders());
        registration.addInitParameter("cors.exposed.headers", this.camundaBpmRunProperties.getCors().getExposedHeaders());
        registration.addInitParameter("cors.support.credentials", String.valueOf(this.camundaBpmRunProperties.getCors().getAllowCredentials()));
        registration.addInitParameter("cors.preflight.maxage", this.camundaBpmRunProperties.getCors().getPreflightMaxAge());
        return registration;
    }

    @Bean
    public CamundaJerseyResourceConfig camundaRunJerseyResourceConfig() {
        CamundaJerseyResourceConfig camundaJerseyResourceConfig = new CamundaJerseyResourceConfig();
        camundaJerseyResourceConfig.setProperties(Collections.singletonMap("jersey.config.server.wadl.disableWadl", this.camundaBpmRunProperties.getRest().isDisableWadl()));
        return camundaJerseyResourceConfig;
    }
}

