/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.dto;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eximeebpms.bpm.engine.impl.QueryOperator;

public class ConditionQueryParameterDto {
    public static final String EQUALS_OPERATOR_NAME = "eq";
    public static final String NOT_EQUALS_OPERATOR_NAME = "neq";
    public static final String GREATER_THAN_OPERATOR_NAME = "gt";
    public static final String GREATER_THAN_OR_EQUALS_OPERATOR_NAME = "gteq";
    public static final String LESS_THAN_OPERATOR_NAME = "lt";
    public static final String LESS_THAN_OR_EQUALS_OPERATOR_NAME = "lteq";
    public static final String LIKE_OPERATOR_NAME = "like";
    public static final String NOT_LIKE_OPERATOR_NAME = "notLike";
    protected static final Map<String, QueryOperator> NAME_OPERATOR_MAP = new HashMap<String, QueryOperator>();
    protected static final Map<QueryOperator, String> OPERATOR_NAME_MAP;
    protected String operator;
    protected Object value;

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Object resolveValue(ObjectMapper objectMapper) {
        if (this.value instanceof String && objectMapper != null) {
            try {
                return objectMapper.readValue("\"" + this.value + "\"", Date.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public static QueryOperator getQueryOperator(String name) {
        return NAME_OPERATOR_MAP.get(name);
    }

    static {
        NAME_OPERATOR_MAP.put(EQUALS_OPERATOR_NAME, QueryOperator.EQUALS);
        NAME_OPERATOR_MAP.put(NOT_EQUALS_OPERATOR_NAME, QueryOperator.NOT_EQUALS);
        NAME_OPERATOR_MAP.put(GREATER_THAN_OPERATOR_NAME, QueryOperator.GREATER_THAN);
        NAME_OPERATOR_MAP.put(GREATER_THAN_OR_EQUALS_OPERATOR_NAME, QueryOperator.GREATER_THAN_OR_EQUAL);
        NAME_OPERATOR_MAP.put(LESS_THAN_OPERATOR_NAME, QueryOperator.LESS_THAN);
        NAME_OPERATOR_MAP.put(LESS_THAN_OR_EQUALS_OPERATOR_NAME, QueryOperator.LESS_THAN_OR_EQUAL);
        NAME_OPERATOR_MAP.put(LIKE_OPERATOR_NAME, QueryOperator.LIKE);
        NAME_OPERATOR_MAP.put(NOT_LIKE_OPERATOR_NAME, QueryOperator.NOT_LIKE);
        OPERATOR_NAME_MAP = new HashMap<QueryOperator, String>();
        OPERATOR_NAME_MAP.put(QueryOperator.EQUALS, EQUALS_OPERATOR_NAME);
        OPERATOR_NAME_MAP.put(QueryOperator.NOT_EQUALS, NOT_EQUALS_OPERATOR_NAME);
        OPERATOR_NAME_MAP.put(QueryOperator.GREATER_THAN, GREATER_THAN_OPERATOR_NAME);
        OPERATOR_NAME_MAP.put(QueryOperator.GREATER_THAN_OR_EQUAL, GREATER_THAN_OR_EQUALS_OPERATOR_NAME);
        OPERATOR_NAME_MAP.put(QueryOperator.LESS_THAN, LESS_THAN_OPERATOR_NAME);
        OPERATOR_NAME_MAP.put(QueryOperator.LESS_THAN_OR_EQUAL, LESS_THAN_OR_EQUALS_OPERATOR_NAME);
        OPERATOR_NAME_MAP.put(QueryOperator.LIKE, LIKE_OPERATOR_NAME);
        OPERATOR_NAME_MAP.put(QueryOperator.NOT_LIKE, NOT_LIKE_OPERATOR_NAME);
    }
}

