/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.dto.batch;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.batch.BatchStatisticsQuery;
import org.eximeebpms.bpm.engine.rest.dto.AbstractQueryDto;
import org.eximeebpms.bpm.engine.rest.dto.CamundaQueryParam;
import org.eximeebpms.bpm.engine.rest.dto.converter.BooleanConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.DateConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.StringListConverter;

public class BatchStatisticsQueryDto
extends AbstractQueryDto<BatchStatisticsQuery> {
    private static final String SORT_BY_BATCH_ID_VALUE = "batchId";
    private static final String SORT_BY_TENANT_ID_VALUE = "tenantId";
    private static final String SORT_BY_START_TIME_VALUE = "startTime";
    protected String batchId;
    protected String type;
    protected List<String> tenantIds;
    protected Boolean withoutTenantId;
    protected Boolean suspended;
    protected String userId;
    protected Date startedBefore;
    protected Date startedAfter;
    protected Boolean withFailures;
    protected Boolean withoutFailures;
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();

    public BatchStatisticsQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="batchId")
    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    @CamundaQueryParam(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @CamundaQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @CamundaQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @CamundaQueryParam(value="suspended", converter=BooleanConverter.class)
    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    @CamundaQueryParam(value="createdBy")
    public void setCreateUserId(String userId) {
        this.userId = userId;
    }

    @CamundaQueryParam(value="startedBefore", converter=DateConverter.class)
    public void setStartedBefore(Date startedBefore) {
        this.startedBefore = startedBefore;
    }

    @CamundaQueryParam(value="startedAfter", converter=DateConverter.class)
    public void setStartedAfter(Date startedAfter) {
        this.startedAfter = startedAfter;
    }

    @CamundaQueryParam(value="withFailures", converter=BooleanConverter.class)
    public void setWithFailures(Boolean withFailures) {
        this.withFailures = withFailures;
    }

    @CamundaQueryParam(value="withoutFailures", converter=BooleanConverter.class)
    public void setWithoutFailures(Boolean withoutFailures) {
        this.withoutFailures = withoutFailures;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected BatchStatisticsQuery createNewQuery(ProcessEngine engine) {
        return engine.getManagementService().createBatchStatisticsQuery();
    }

    @Override
    protected void applyFilters(BatchStatisticsQuery query) {
        if (this.batchId != null) {
            query.batchId(this.batchId);
        }
        if (this.type != null) {
            query.type(this.type);
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (Boolean.TRUE.equals(this.suspended)) {
            query.suspended();
        }
        if (Boolean.FALSE.equals(this.suspended)) {
            query.active();
        }
        if (this.userId != null) {
            query.createdBy(this.userId);
        }
        if (this.startedBefore != null) {
            query.startedBefore(this.startedBefore);
        }
        if (this.startedAfter != null) {
            query.startedAfter(this.startedAfter);
        }
        if (Boolean.TRUE.equals(this.withFailures)) {
            query.withFailures();
        }
        if (Boolean.TRUE.equals(this.withoutFailures)) {
            query.withoutFailures();
        }
    }

    @Override
    protected void applySortBy(BatchStatisticsQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_BATCH_ID_VALUE)) {
            query.orderById();
        } else if (sortBy.equals(SORT_BY_TENANT_ID_VALUE)) {
            query.orderByTenantId();
        } else if (sortBy.equals(SORT_BY_START_TIME_VALUE)) {
            query.orderByStartTime();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_BATCH_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_START_TIME_VALUE);
    }
}

