/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.history.CleanableHistoricProcessInstanceReport;
import org.eximeebpms.bpm.engine.rest.dto.AbstractQueryDto;
import org.eximeebpms.bpm.engine.rest.dto.CamundaQueryParam;
import org.eximeebpms.bpm.engine.rest.dto.converter.BooleanConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.StringArrayConverter;

public class CleanableHistoricProcessInstanceReportDto
extends AbstractQueryDto<CleanableHistoricProcessInstanceReport> {
    protected String[] processDefinitionIdIn;
    protected String[] processDefinitionKeyIn;
    protected String[] tenantIdIn;
    protected Boolean withoutTenantId;
    protected Boolean compact;
    protected static final String SORT_BY_FINISHED_VALUE = "finished";
    public static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();

    public CleanableHistoricProcessInstanceReportDto() {
    }

    public CleanableHistoricProcessInstanceReportDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="processDefinitionIdIn", converter=StringArrayConverter.class)
    public void setProcessDefinitionIdIn(String[] processDefinitionIdIn) {
        this.processDefinitionIdIn = processDefinitionIdIn;
    }

    @CamundaQueryParam(value="processDefinitionKeyIn", converter=StringArrayConverter.class)
    public void setProcessDefinitionKeyIn(String[] processDefinitionKeyIn) {
        this.processDefinitionKeyIn = processDefinitionKeyIn;
    }

    @CamundaQueryParam(value="tenantIdIn", converter=StringArrayConverter.class)
    public void setTenantIdIn(String[] tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
    }

    @CamundaQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @CamundaQueryParam(value="compact", converter=BooleanConverter.class)
    public void setCompact(Boolean compact) {
        this.compact = compact;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected CleanableHistoricProcessInstanceReport createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createCleanableHistoricProcessInstanceReport();
    }

    @Override
    protected void applyFilters(CleanableHistoricProcessInstanceReport query) {
        if (this.processDefinitionIdIn != null && this.processDefinitionIdIn.length > 0) {
            query.processDefinitionIdIn(this.processDefinitionIdIn);
        }
        if (this.processDefinitionKeyIn != null && this.processDefinitionKeyIn.length > 0) {
            query.processDefinitionKeyIn(this.processDefinitionKeyIn);
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (this.tenantIdIn != null && this.tenantIdIn.length > 0) {
            query.tenantIdIn(this.tenantIdIn);
        }
        if (Boolean.TRUE.equals(this.compact)) {
            query.compact();
        }
    }

    @Override
    protected void applySortBy(CleanableHistoricProcessInstanceReport query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_FINISHED_VALUE)) {
            query.orderByFinished();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_FINISHED_VALUE);
    }
}

