/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.dto.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.rest.dto.AbstractQueryDto;
import org.eximeebpms.bpm.engine.rest.dto.CamundaQueryParam;
import org.eximeebpms.bpm.engine.rest.dto.converter.DateConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.StringArrayConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.StringListConverter;
import org.eximeebpms.bpm.engine.runtime.IncidentQuery;

public class IncidentQueryDto
extends AbstractQueryDto<IncidentQuery> {
    private static final String SORT_BY_INCIDENT_ID = "incidentId";
    private static final String SORT_BY_INCIDENT_MESSAGE = "incidentMessage";
    private static final String SORT_BY_INCIDENT_TIMESTAMP = "incidentTimestamp";
    private static final String SORT_BY_INCIDENT_TYPE = "incidentType";
    private static final String SORT_BY_EXECUTION_ID = "executionId";
    private static final String SORT_BY_ACTIVITY_ID = "activityId";
    private static final String SORT_BY_PROCESS_INSTANCE_ID = "processInstanceId";
    private static final String SORT_BY_PROCESS_DEFINITION_ID = "processDefinitionId";
    private static final String SORT_BY_CAUSE_INCIDENT_ID = "causeIncidentId";
    private static final String SORT_BY_ROOT_CAUSE_INCIDENT_ID = "rootCauseIncidentId";
    private static final String SORT_BY_CONFIGURATION = "configuration";
    private static final String SORT_BY_TENANT_ID = "tenantId";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String incidentId;
    protected String incidentType;
    protected String incidentMessage;
    protected String incidentMessageLike;
    protected String processDefinitionId;
    protected String[] processDefinitionKeyIn;
    protected String processInstanceId;
    protected String executionId;
    protected Date incidentTimestampBefore;
    protected Date incidentTimestampAfter;
    protected String activityId;
    protected String failedActivityId;
    protected String causeIncidentId;
    protected String rootCauseIncidentId;
    protected String configuration;
    protected List<String> tenantIds;
    protected List<String> jobDefinitionIds;

    public IncidentQueryDto() {
    }

    public IncidentQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="incidentId")
    public void setIncidentId(String incidentId) {
        this.incidentId = incidentId;
    }

    @CamundaQueryParam(value="incidentType")
    public void setIncidentType(String incidentType) {
        this.incidentType = incidentType;
    }

    @CamundaQueryParam(value="incidentMessage")
    public void setIncidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
    }

    @CamundaQueryParam(value="incidentMessageLike")
    public void setIncidentMessageLike(String incidentMessageLike) {
        this.incidentMessageLike = incidentMessageLike;
    }

    @CamundaQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @CamundaQueryParam(value="processDefinitionKeyIn", converter=StringArrayConverter.class)
    public void setProcessDefinitionKeyIn(String[] processDefinitionKeyIn) {
        this.processDefinitionKeyIn = processDefinitionKeyIn;
    }

    @CamundaQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @CamundaQueryParam(value="executionId")
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @CamundaQueryParam(value="incidentTimestampAfter", converter=DateConverter.class)
    public void setIncidentTimestampAfter(Date incidentTimestampAfter) {
        this.incidentTimestampAfter = incidentTimestampAfter;
    }

    @CamundaQueryParam(value="incidentTimestampBefore", converter=DateConverter.class)
    public void setIncidentTimestampBefore(Date incidentTimestampBefore) {
        this.incidentTimestampBefore = incidentTimestampBefore;
    }

    @CamundaQueryParam(value="activityId")
    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @CamundaQueryParam(value="failedActivityId")
    public void setFailedActivityId(String activityId) {
        this.failedActivityId = activityId;
    }

    @CamundaQueryParam(value="causeIncidentId")
    public void setCauseIncidentId(String causeIncidentId) {
        this.causeIncidentId = causeIncidentId;
    }

    @CamundaQueryParam(value="rootCauseIncidentId")
    public void setRootCauseIncidentId(String rootCauseIncidentId) {
        this.rootCauseIncidentId = rootCauseIncidentId;
    }

    @CamundaQueryParam(value="configuration")
    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    @CamundaQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @CamundaQueryParam(value="jobDefinitionIdIn", converter=StringListConverter.class)
    public void setJobDefinitionIdIn(List<String> jobDefinitionIds) {
        this.jobDefinitionIds = jobDefinitionIds;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected IncidentQuery createNewQuery(ProcessEngine engine) {
        return engine.getRuntimeService().createIncidentQuery();
    }

    @Override
    protected void applyFilters(IncidentQuery query) {
        if (this.incidentId != null) {
            query.incidentId(this.incidentId);
        }
        if (this.incidentType != null) {
            query.incidentType(this.incidentType);
        }
        if (this.incidentMessage != null) {
            query.incidentMessage(this.incidentMessage);
        }
        if (this.incidentMessageLike != null) {
            query.incidentMessageLike(this.incidentMessageLike);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionKeyIn != null && this.processDefinitionKeyIn.length > 0) {
            query.processDefinitionKeyIn(this.processDefinitionKeyIn);
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.executionId != null) {
            query.executionId(this.executionId);
        }
        if (this.incidentTimestampBefore != null) {
            query.incidentTimestampBefore(this.incidentTimestampBefore);
        }
        if (this.incidentTimestampAfter != null) {
            query.incidentTimestampAfter(this.incidentTimestampAfter);
        }
        if (this.activityId != null) {
            query.activityId(this.activityId);
        }
        if (this.failedActivityId != null) {
            query.failedActivityId(this.failedActivityId);
        }
        if (this.causeIncidentId != null) {
            query.causeIncidentId(this.causeIncidentId);
        }
        if (this.rootCauseIncidentId != null) {
            query.rootCauseIncidentId(this.rootCauseIncidentId);
        }
        if (this.configuration != null) {
            query.configuration(this.configuration);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (this.jobDefinitionIds != null && !this.jobDefinitionIds.isEmpty()) {
            query.jobDefinitionIdIn(this.jobDefinitionIds.toArray(new String[this.jobDefinitionIds.size()]));
        }
    }

    @Override
    protected void applySortBy(IncidentQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_INCIDENT_ID)) {
            query.orderByIncidentId();
        } else if (sortBy.equals(SORT_BY_INCIDENT_MESSAGE)) {
            query.orderByIncidentMessage();
        } else if (sortBy.equals(SORT_BY_INCIDENT_TIMESTAMP)) {
            query.orderByIncidentTimestamp();
        } else if (sortBy.equals(SORT_BY_INCIDENT_TYPE)) {
            query.orderByIncidentType();
        } else if (sortBy.equals(SORT_BY_EXECUTION_ID)) {
            query.orderByExecutionId();
        } else if (sortBy.equals(SORT_BY_ACTIVITY_ID)) {
            query.orderByActivityId();
        } else if (sortBy.equals(SORT_BY_PROCESS_INSTANCE_ID)) {
            query.orderByProcessInstanceId();
        } else if (sortBy.equals(SORT_BY_PROCESS_DEFINITION_ID)) {
            query.orderByProcessDefinitionId();
        } else if (sortBy.equals(SORT_BY_CAUSE_INCIDENT_ID)) {
            query.orderByCauseIncidentId();
        } else if (sortBy.equals(SORT_BY_ROOT_CAUSE_INCIDENT_ID)) {
            query.orderByRootCauseIncidentId();
        } else if (sortBy.equals(SORT_BY_CONFIGURATION)) {
            query.orderByConfiguration();
        } else if (sortBy.equals(SORT_BY_TENANT_ID)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_INCIDENT_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_INCIDENT_MESSAGE);
        VALID_SORT_BY_VALUES.add(SORT_BY_INCIDENT_TIMESTAMP);
        VALID_SORT_BY_VALUES.add(SORT_BY_INCIDENT_TYPE);
        VALID_SORT_BY_VALUES.add(SORT_BY_EXECUTION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_ACTIVITY_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_CAUSE_INCIDENT_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_ROOT_CAUSE_INCIDENT_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_CONFIGURATION);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

