/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.sub.repository.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.Closeable;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Map;
import org.eximeebpms.bpm.engine.CaseService;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.exception.NotAllowedException;
import org.eximeebpms.bpm.engine.exception.NotFoundException;
import org.eximeebpms.bpm.engine.exception.NotValidException;
import org.eximeebpms.bpm.engine.impl.util.IoUtil;
import org.eximeebpms.bpm.engine.repository.CaseDefinition;
import org.eximeebpms.bpm.engine.rest.dto.HistoryTimeToLiveDto;
import org.eximeebpms.bpm.engine.rest.dto.VariableValueDto;
import org.eximeebpms.bpm.engine.rest.dto.repository.CaseDefinitionDiagramDto;
import org.eximeebpms.bpm.engine.rest.dto.repository.CaseDefinitionDto;
import org.eximeebpms.bpm.engine.rest.dto.runtime.CaseInstanceDto;
import org.eximeebpms.bpm.engine.rest.dto.runtime.CreateCaseInstanceDto;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.exception.RestException;
import org.eximeebpms.bpm.engine.rest.sub.repository.CaseDefinitionResource;
import org.eximeebpms.bpm.engine.rest.sub.repository.impl.ProcessDefinitionResourceImpl;
import org.eximeebpms.bpm.engine.rest.util.URLEncodingUtil;
import org.eximeebpms.bpm.engine.runtime.CaseInstance;
import org.eximeebpms.bpm.engine.variable.VariableMap;

public class CaseDefinitionResourceImpl
implements CaseDefinitionResource {
    protected ProcessEngine engine;
    protected String caseDefinitionId;
    protected String rootResourcePath;
    protected ObjectMapper objectMapper;

    public CaseDefinitionResourceImpl(ProcessEngine engine, String caseDefinitionId, String rootResourcePath, ObjectMapper objectMapper) {
        this.engine = engine;
        this.caseDefinitionId = caseDefinitionId;
        this.rootResourcePath = rootResourcePath;
        this.objectMapper = objectMapper;
    }

    @Override
    public CaseDefinitionDto getCaseDefinition() {
        RepositoryService repositoryService = this.engine.getRepositoryService();
        CaseDefinition definition = null;
        try {
            definition = repositoryService.getCaseDefinition(this.caseDefinitionId);
        }
        catch (NotFoundException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, (Exception)((Object)e), e.getMessage());
        }
        catch (NotValidException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), e.getMessage());
        }
        catch (ProcessEngineException e) {
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e));
        }
        return CaseDefinitionDto.fromCaseDefinition(definition);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CaseDefinitionDiagramDto getCaseDefinitionCmmnXml() {
        CaseDefinitionDiagramDto caseDefinitionDiagramDto;
        InputStream caseModelInputStream = null;
        try {
            caseModelInputStream = this.engine.getRepositoryService().getCaseModel(this.caseDefinitionId);
            byte[] caseModel = IoUtil.readInputStream((InputStream)caseModelInputStream, (String)"caseModelCmmnXml");
            caseDefinitionDiagramDto = CaseDefinitionDiagramDto.create(this.caseDefinitionId, new String(caseModel, "UTF-8"));
        }
        catch (NotFoundException e) {
            try {
                throw new InvalidRequestException(Response.Status.NOT_FOUND, (Exception)((Object)e), e.getMessage());
                catch (NotValidException e2) {
                    throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e2), e2.getMessage());
                }
                catch (ProcessEngineException e3) {
                    throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e3));
                }
                catch (UnsupportedEncodingException e4) {
                    throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e4);
                }
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(caseModelInputStream);
                throw throwable;
            }
        }
        IoUtil.closeSilently((Closeable)caseModelInputStream);
        return caseDefinitionDiagramDto;
    }

    @Override
    public CaseInstanceDto createCaseInstance(UriInfo context, CreateCaseInstanceDto parameters) {
        CaseService caseService = this.engine.getCaseService();
        CaseInstance instance = null;
        try {
            String businessKey = parameters.getBusinessKey();
            VariableMap variables = VariableValueDto.toMap(parameters.getVariables(), this.engine, this.objectMapper);
            instance = caseService.withCaseDefinition(this.caseDefinitionId).businessKey(businessKey).setVariables((Map)variables).create();
        }
        catch (RestException e) {
            String errorMessage = String.format("Cannot instantiate case definition %s: %s", this.caseDefinitionId, e.getMessage());
            throw new InvalidRequestException(e.getStatus(), e, errorMessage);
        }
        catch (NotFoundException e) {
            String errorMessage = String.format("Cannot instantiate case definition %s: %s", this.caseDefinitionId, e.getMessage());
            throw new InvalidRequestException(Response.Status.NOT_FOUND, (Exception)((Object)e), errorMessage);
        }
        catch (NotValidException e) {
            String errorMessage = String.format("Cannot instantiate case definition %s: %s", this.caseDefinitionId, e.getMessage());
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), errorMessage);
        }
        catch (NotAllowedException e) {
            String errorMessage = String.format("Cannot instantiate case definition %s: %s", this.caseDefinitionId, e.getMessage());
            throw new InvalidRequestException(Response.Status.FORBIDDEN, (Exception)((Object)e), errorMessage);
        }
        catch (ProcessEngineException e) {
            String errorMessage = String.format("Cannot instantiate case definition %s: %s", this.caseDefinitionId, e.getMessage());
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), errorMessage);
        }
        CaseInstanceDto result = CaseInstanceDto.fromCaseInstance(instance);
        URI uri = context.getBaseUriBuilder().path(this.rootResourcePath).path("/case-instance").path(instance.getId()).build(new Object[0]);
        result.addReflexiveLink(uri, "GET", "self");
        return result;
    }

    @Override
    public Response getCaseDefinitionDiagram() {
        CaseDefinition definition = this.engine.getRepositoryService().getCaseDefinition(this.caseDefinitionId);
        InputStream caseDiagram = this.engine.getRepositoryService().getCaseDiagram(this.caseDefinitionId);
        if (caseDiagram == null) {
            return Response.noContent().build();
        }
        String fileName = definition.getDiagramResourceName();
        return Response.ok((Object)caseDiagram).header("Content-Disposition", (Object)URLEncodingUtil.buildAttachmentValue(fileName)).type(ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix(fileName)).build();
    }

    @Override
    public void updateHistoryTimeToLive(HistoryTimeToLiveDto historyTimeToLiveDto) {
        this.engine.getRepositoryService().updateCaseDefinitionHistoryTimeToLive(this.caseDefinitionId, historyTimeToLiveDto.getHistoryTimeToLive());
    }
}

