/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.sub.task.impl;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eximeebpms.bpm.engine.AuthorizationException;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.history.HistoricTaskInstance;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.identity.Authentication;
import org.eximeebpms.bpm.engine.rest.dto.task.CommentDto;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.sub.task.TaskCommentResource;
import org.eximeebpms.bpm.engine.task.Comment;

public class TaskCommentResourceImpl
implements TaskCommentResource {
    private ProcessEngine engine;
    private String taskId;
    private String rootResourcePath;

    public TaskCommentResourceImpl(ProcessEngine engine, String taskId, String rootResourcePath) {
        this.engine = engine;
        this.taskId = taskId;
        this.rootResourcePath = rootResourcePath;
    }

    @Override
    public List<CommentDto> getComments() {
        if (!this.isHistoryEnabled()) {
            return Collections.emptyList();
        }
        this.ensureTaskExists(Response.Status.NOT_FOUND);
        List taskComments = this.engine.getTaskService().getTaskComments(this.taskId);
        ArrayList<CommentDto> comments = new ArrayList<CommentDto>();
        for (Comment comment : taskComments) {
            comments.add(CommentDto.fromComment(comment));
        }
        return comments;
    }

    @Override
    public CommentDto getComment(String commentId) {
        this.ensureHistoryEnabled(Response.Status.NOT_FOUND);
        Comment comment = this.engine.getTaskService().getTaskComment(this.taskId, commentId);
        if (comment == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Task comment with id " + commentId + " does not exist for task id '" + this.taskId + "'.");
        }
        return CommentDto.fromComment(comment);
    }

    @Override
    public void deleteComment(String commentId) {
        this.ensureHistoryEnabled(Response.Status.FORBIDDEN);
        this.ensureTaskExists(Response.Status.NOT_FOUND);
        TaskService taskService = this.engine.getTaskService();
        try {
            taskService.deleteTaskComment(this.taskId, commentId);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (NullValueException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @Override
    public void updateComment(CommentDto comment) {
        this.ensureHistoryEnabled(Response.Status.FORBIDDEN);
        this.ensureTaskExists(Response.Status.NOT_FOUND);
        try {
            this.engine.getTaskService().updateTaskComment(this.taskId, comment.getId(), comment.getMessage());
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (NullValueException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @Override
    public void deleteComments() {
        this.ensureHistoryEnabled(Response.Status.FORBIDDEN);
        this.ensureTaskExists(Response.Status.NOT_FOUND);
        TaskService taskService = this.engine.getTaskService();
        try {
            taskService.deleteTaskComments(this.taskId);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (NullValueException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @Override
    public CommentDto createComment(UriInfo uriInfo, CommentDto commentDto) {
        Comment comment;
        this.ensureHistoryEnabled(Response.Status.FORBIDDEN);
        this.ensureTaskExists(Response.Status.BAD_REQUEST);
        String processInstanceId = commentDto.getProcessInstanceId();
        try {
            comment = this.engine.getTaskService().createComment(this.taskId, processInstanceId, commentDto.getMessage());
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Not enough parameters submitted");
        }
        URI uri = uriInfo.getBaseUriBuilder().path(this.rootResourcePath).path("/task").path(this.taskId + "/comment/" + comment.getId()).build(new Object[0]);
        CommentDto resultDto = CommentDto.fromComment(comment);
        resultDto.addReflexiveLink(uri, "GET", "self");
        return resultDto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHistoryEnabled() {
        IdentityService identityService = this.engine.getIdentityService();
        Authentication currentAuthentication = identityService.getCurrentAuthentication();
        try {
            identityService.clearAuthentication();
            int historyLevel = this.engine.getManagementService().getHistoryLevel();
            boolean bl = historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE;
            return bl;
        }
        finally {
            identityService.setAuthentication(currentAuthentication);
        }
    }

    private void ensureHistoryEnabled(Response.Status status) {
        if (!this.isHistoryEnabled()) {
            throw new InvalidRequestException(status, "History is not enabled");
        }
    }

    private void ensureTaskExists(Response.Status status) {
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.engine.getHistoryService().createHistoricTaskInstanceQuery().taskId(this.taskId).singleResult();
        if (historicTaskInstance == null) {
            throw new InvalidRequestException(status, "No task found for task id " + this.taskId);
        }
    }
}

