/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.spring.boot.starter.rest;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.util.EnumSet;
import java.util.Map;
import org.eximeebpms.bpm.engine.rest.filter.CacheControlFilter;
import org.eximeebpms.bpm.engine.rest.filter.EmptyBodyFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.servlet.JerseyApplicationPath;
import org.springframework.boot.web.servlet.ServletContextInitializer;

public class CamundaBpmRestInitializer
implements ServletContextInitializer {
    private static final Logger log = LoggerFactory.getLogger(CamundaBpmRestInitializer.class);
    private static final EnumSet<DispatcherType> DISPATCHER_TYPES = EnumSet.of(DispatcherType.REQUEST);
    private ServletContext servletContext;
    private JerseyApplicationPath applicationPath;

    public CamundaBpmRestInitializer(JerseyApplicationPath applicationPath) {
        this.applicationPath = applicationPath;
    }

    public void onStartup(ServletContext servletContext) throws ServletException {
        this.servletContext = servletContext;
        String restApiPathPattern = this.applicationPath.getUrlMapping();
        this.registerFilter("EmptyBodyFilter", EmptyBodyFilter.class, restApiPathPattern);
        this.registerFilter("CacheControlFilter", CacheControlFilter.class, restApiPathPattern);
    }

    private FilterRegistration registerFilter(String filterName, Class<? extends Filter> filterClass, String ... urlPatterns) {
        return this.registerFilter(filterName, filterClass, (Map<String, String>)null, urlPatterns);
    }

    private FilterRegistration registerFilter(String filterName, Class<? extends Filter> filterClass, Map<String, String> initParameters, String ... urlPatterns) {
        FilterRegistration filterRegistration = this.servletContext.getFilterRegistration(filterName);
        if (filterRegistration == null) {
            filterRegistration = this.servletContext.addFilter(filterName, filterClass);
            filterRegistration.addMappingForUrlPatterns(DISPATCHER_TYPES, true, urlPatterns);
            if (initParameters != null) {
                filterRegistration.setInitParameters(initParameters);
            }
            log.debug("Filter {} for URL {} registered.", (Object)filterName, (Object)urlPatterns);
        }
        return filterRegistration;
    }
}

