/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.run.example.invoice;

import jakarta.annotation.PostConstruct;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.example.invoice.InvoiceApplicationHelper;
import org.eximeebpms.bpm.example.invoice.InvoiceProcessApplication;
import org.eximeebpms.bpm.spring.boot.starter.annotation.EnableProcessApplication;
import org.eximeebpms.bpm.spring.boot.starter.event.PostDeployEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnProperty(name={"enabled"}, havingValue="true", prefix="eximeebpms.bpm.run.example")
@Configuration
@EnableProcessApplication(value="invoiceProcessApplicationSpringBoot")
public class Application
implements WebMvcConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(Application.class);
    @Autowired
    protected ProcessEngine processEngine;
    protected InvoiceProcessApplication invoicePa = new InvoiceProcessApplication();

    @PostConstruct
    public void deployInvoice() {
        LOG.info("Invoice example started, creating deployment");
        InvoiceApplicationHelper.createDeployment("invoiceProcessApplicationSpringBoot", this.processEngine, ((Object)((Object)this.invoicePa)).getClass().getClassLoader(), this.invoicePa.getReference());
    }

    @EventListener
    public void onPostDeploy(PostDeployEvent event) {
        LOG.info("Starting invoice example instance");
        this.invoicePa.startFirstProcess(event.getProcessEngine());
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/forms/**"}).addResourceLocations(new String[]{"classpath:/forms/"});
        registry.addResourceHandler(new String[]{"/eximeebpms-invoice/**"}).addResourceLocations(new String[]{"classpath:/eximeebpms-invoice/"});
    }
}

