/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.spring.boot.starter.security.oauth2.impl;

import jakarta.annotation.Nonnull;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.web.filter.OncePerRequestFilter;

public class AuthorizeTokenFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizeTokenFilter.class);
    private final OAuth2AuthorizedClientManager clientManager;

    public AuthorizeTokenFilter(OAuth2AuthorizedClientManager clientManager) {
        this.clientManager = clientManager;
    }

    protected void doFilterInternal(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull FilterChain filterChain) throws ServletException, IOException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof OAuth2AuthenticationToken) {
            OAuth2AuthenticationToken token = (OAuth2AuthenticationToken)authentication;
            this.authorizeToken(token, request, response);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected boolean hasTokenExpired(OAuth2Token token) {
        return token.getExpiresAt() == null || ClockUtil.now().after(Date.from(token.getExpiresAt()));
    }

    protected void clearContext(HttpServletRequest request) {
        SecurityContextHolder.clearContext();
        try {
            request.getSession().invalidate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void authorizeToken(OAuth2AuthenticationToken token, HttpServletRequest request, HttpServletResponse response) {
        OAuth2AuthorizeRequest authRequest = OAuth2AuthorizeRequest.withClientRegistrationId((String)token.getAuthorizedClientRegistrationId()).principal((Authentication)token).attributes(attrs -> {
            attrs.put(HttpServletRequest.class.getName(), request);
            attrs.put(HttpServletResponse.class.getName(), response);
        }).build();
        String name = token.getName();
        try {
            OAuth2AuthorizedClient res = this.clientManager.authorize(authRequest);
            if (res == null || this.hasTokenExpired((OAuth2Token)res.getAccessToken())) {
                logger.warn("Authorize failed for '{}': could not re-authorize expired access token", (Object)name);
                this.clearContext(request);
            } else {
                logger.debug("Authorize successful for '{}', access token expiry: {}", (Object)name, (Object)res.getAccessToken().getExpiresAt());
            }
        }
        catch (OAuth2AuthorizationException e) {
            logger.warn("Authorize failed for '{}': {}", (Object)name, (Object)e.getMessage());
            this.clearContext(request);
        }
    }
}

