/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.spring.boot.starter.security.oauth2.impl;

import jakarta.servlet.http.HttpServletRequest;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.rest.security.auth.AuthenticationResult;
import org.eximeebpms.bpm.engine.rest.security.auth.impl.ContainerBasedAuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;

public class OAuth2AuthenticationProvider
extends ContainerBasedAuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(OAuth2AuthenticationProvider.class);

    public AuthenticationResult extractAuthenticatedUser(HttpServletRequest request, ProcessEngine engine) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            logger.debug("Authentication is null");
            return AuthenticationResult.unsuccessful();
        }
        if (!(authentication instanceof OAuth2AuthenticationToken)) {
            logger.debug("Authentication is not OAuth2, it is {}", authentication.getClass());
            return AuthenticationResult.unsuccessful();
        }
        OAuth2AuthenticationToken oauth2 = (OAuth2AuthenticationToken)authentication;
        String camundaUserId = oauth2.getName();
        if (camundaUserId == null || camundaUserId.isEmpty()) {
            logger.debug("UserId is empty");
            return AuthenticationResult.unsuccessful();
        }
        logger.debug("Authenticated user '{}'", (Object)camundaUserId);
        return AuthenticationResult.successful((String)camundaUserId);
    }
}

