/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.spring.boot.starter.security.oauth2.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eximeebpms.bpm.spring.boot.starter.security.oauth2.OAuth2Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.oauth2.core.user.OAuth2UserAuthority;

public class OAuth2GrantedAuthoritiesMapper
implements GrantedAuthoritiesMapper {
    private static final Logger logger = LoggerFactory.getLogger(OAuth2GrantedAuthoritiesMapper.class);
    private final OAuth2Properties oAuth2Properties;

    public OAuth2GrantedAuthoritiesMapper(OAuth2Properties oAuth2Properties) {
        this.oAuth2Properties = oAuth2Properties;
    }

    public Collection<? extends GrantedAuthority> mapAuthorities(Collection<? extends GrantedAuthority> authorities) {
        OAuth2Properties.OAuth2IdentityProviderProperties identityProviderProperties = this.oAuth2Properties.getIdentityProvider();
        String groupNameAttribute = identityProviderProperties.getGroupNameAttribute();
        HashSet mappedAuthorities = new HashSet();
        authorities.forEach(authority -> {
            if (authority instanceof OAuth2UserAuthority) {
                OAuth2UserAuthority oauth2UserAuthority = (OAuth2UserAuthority)authority;
                Object groupAttribute = oauth2UserAuthority.getAttributes().get(groupNameAttribute);
                if (groupAttribute == null) {
                    logger.debug("Attribute {} is not available", (Object)groupNameAttribute);
                    return;
                }
                if (groupAttribute instanceof Collection) {
                    Collection groupsAttribute = (Collection)groupAttribute;
                    Set grantedAuthorities = groupsAttribute.stream().map(SimpleGrantedAuthority::new).collect(Collectors.toSet());
                    mappedAuthorities.addAll(grantedAuthorities);
                } else if (groupAttribute instanceof String) {
                    String groupNameDelimiter = identityProviderProperties.getGroupNameDelimiter();
                    String groupsAttribute = (String)groupAttribute;
                    Set grantedAuthorities = Arrays.stream(groupsAttribute.split(groupNameDelimiter)).map(SimpleGrantedAuthority::new).collect(Collectors.toSet());
                    mappedAuthorities.addAll(grantedAuthorities);
                } else {
                    logger.error("Could not map granted authorities, unsupported group attribute type: {}", groupAttribute.getClass());
                }
            }
        });
        logger.debug("Authorities mapped from {} to {}", authorities, mappedAuthorities);
        return mappedAuthorities;
    }
}

