/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.repository.DecisionDefinition;
import org.eximeebpms.bpm.engine.repository.DecisionDefinitionQuery;
import org.eximeebpms.bpm.engine.rest.DecisionDefinitionRestService;
import org.eximeebpms.bpm.engine.rest.dto.CountResultDto;
import org.eximeebpms.bpm.engine.rest.dto.repository.DecisionDefinitionDto;
import org.eximeebpms.bpm.engine.rest.dto.repository.DecisionDefinitionQueryDto;
import org.eximeebpms.bpm.engine.rest.exception.RestException;
import org.eximeebpms.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.eximeebpms.bpm.engine.rest.sub.repository.DecisionDefinitionResource;
import org.eximeebpms.bpm.engine.rest.sub.repository.impl.DecisionDefinitionResourceImpl;
import org.eximeebpms.bpm.engine.rest.util.QueryUtil;

public class DecisionDefinitionRestServiceImpl
extends AbstractRestProcessEngineAware
implements DecisionDefinitionRestService {
    public DecisionDefinitionRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public DecisionDefinitionResource getDecisionDefinitionByKey(String decisionDefinitionKey) {
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.getProcessEngine().getRepositoryService().createDecisionDefinitionQuery().decisionDefinitionKey(decisionDefinitionKey).withoutTenantId().latestVersion().singleResult();
        if (decisionDefinition == null) {
            String errorMessage = String.format("No matching decision definition with key: %s and no tenant-id", decisionDefinitionKey);
            throw new RestException(Response.Status.NOT_FOUND, errorMessage);
        }
        return this.getDecisionDefinitionById(decisionDefinition.getId());
    }

    @Override
    public DecisionDefinitionResource getDecisionDefinitionByKeyAndTenantId(String decisionDefinitionKey, String tenantId) {
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.getProcessEngine().getRepositoryService().createDecisionDefinitionQuery().decisionDefinitionKey(decisionDefinitionKey).tenantIdIn(new String[]{tenantId}).latestVersion().singleResult();
        if (decisionDefinition == null) {
            String errorMessage = String.format("No matching decision definition with key: %s and tenant-id: %s", decisionDefinitionKey, tenantId);
            throw new RestException(Response.Status.NOT_FOUND, errorMessage);
        }
        return this.getDecisionDefinitionById(decisionDefinition.getId());
    }

    @Override
    public DecisionDefinitionResource getDecisionDefinitionById(String decisionDefinitionId) {
        return new DecisionDefinitionResourceImpl(this.getProcessEngine(), decisionDefinitionId, this.relativeRootResourcePath, this.getObjectMapper());
    }

    @Override
    public List<DecisionDefinitionDto> getDecisionDefinitions(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        DecisionDefinitionQueryDto queryDto = new DecisionDefinitionQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        ArrayList<DecisionDefinitionDto> definitions = new ArrayList<DecisionDefinitionDto>();
        ProcessEngine engine = this.getProcessEngine();
        DecisionDefinitionQuery query = (DecisionDefinitionQuery)queryDto.toQuery(engine);
        List<DecisionDefinition> matchingDefinitions = QueryUtil.list(query, firstResult, maxResults);
        for (DecisionDefinition definition : matchingDefinitions) {
            DecisionDefinitionDto def = DecisionDefinitionDto.fromDecisionDefinition(definition);
            definitions.add(def);
        }
        return definitions;
    }

    @Override
    public CountResultDto getDecisionDefinitionsCount(UriInfo uriInfo) {
        DecisionDefinitionQueryDto queryDto = new DecisionDefinitionQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        ProcessEngine engine = this.getProcessEngine();
        DecisionDefinitionQuery query = (DecisionDefinitionQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

