/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.security.auth.impl;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.impl.digest._apacheCommonsCodec.Base64;
import org.eximeebpms.bpm.engine.rest.security.auth.AuthenticationProvider;
import org.eximeebpms.bpm.engine.rest.security.auth.AuthenticationResult;

public class HttpBasicAuthenticationProvider
implements AuthenticationProvider {
    protected static final String BASIC_AUTH_HEADER_PREFIX = "Basic ";

    @Override
    public AuthenticationResult extractAuthenticatedUser(HttpServletRequest request, ProcessEngine engine) {
        String authorizationHeader = request.getHeader("Authorization");
        if (authorizationHeader != null && authorizationHeader.startsWith(BASIC_AUTH_HEADER_PREFIX)) {
            String password;
            String encodedCredentials = authorizationHeader.substring(BASIC_AUTH_HEADER_PREFIX.length());
            String decodedCredentials = new String(Base64.decodeBase64((String)encodedCredentials));
            int firstColonIndex = decodedCredentials.indexOf(":");
            if (firstColonIndex == -1) {
                return AuthenticationResult.unsuccessful();
            }
            String userName = decodedCredentials.substring(0, firstColonIndex);
            if (this.isAuthenticated(engine, userName, password = decodedCredentials.substring(firstColonIndex + 1))) {
                return AuthenticationResult.successful(userName);
            }
            return AuthenticationResult.unsuccessful(userName);
        }
        return AuthenticationResult.unsuccessful();
    }

    protected boolean isAuthenticated(ProcessEngine engine, String userName, String password) {
        return engine.getIdentityService().checkPassword(userName, password);
    }

    @Override
    public void augmentResponseByAuthenticationChallenge(HttpServletResponse response, ProcessEngine engine) {
        response.setHeader("WWW-Authenticate", "Basic realm=\"" + engine.getName() + "\"");
    }
}

