/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.history.HistoricTaskInstance;
import org.eximeebpms.bpm.engine.history.HistoricTaskInstanceQuery;
import org.eximeebpms.bpm.engine.history.HistoricTaskInstanceReportResult;
import org.eximeebpms.bpm.engine.history.ReportResult;
import org.eximeebpms.bpm.engine.rest.dto.CountResultDto;
import org.eximeebpms.bpm.engine.rest.dto.history.HistoricTaskInstanceDto;
import org.eximeebpms.bpm.engine.rest.dto.history.HistoricTaskInstanceQueryDto;
import org.eximeebpms.bpm.engine.rest.dto.history.HistoricTaskInstanceReportQueryDto;
import org.eximeebpms.bpm.engine.rest.dto.history.HistoricTaskInstanceReportResultDto;
import org.eximeebpms.bpm.engine.rest.dto.history.ReportResultDto;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.history.HistoricTaskInstanceRestService;
import org.eximeebpms.bpm.engine.rest.util.QueryUtil;

public class HistoricTaskInstanceRestServiceImpl
implements HistoricTaskInstanceRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricTaskInstanceRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public List<HistoricTaskInstanceDto> getHistoricTaskInstances(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        HistoricTaskInstanceQueryDto queryDto = new HistoricTaskInstanceQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricTaskInstances(queryDto, firstResult, maxResults);
    }

    @Override
    public List<HistoricTaskInstanceDto> queryHistoricTaskInstances(HistoricTaskInstanceQueryDto queryDto, Integer firstResult, Integer maxResults) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricTaskInstanceQuery query = (HistoricTaskInstanceQuery)queryDto.toQuery(this.processEngine);
        List<HistoricTaskInstance> match = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<HistoricTaskInstanceDto> result = new ArrayList<HistoricTaskInstanceDto>();
        for (HistoricTaskInstance taskInstance : match) {
            HistoricTaskInstanceDto taskInstanceDto = HistoricTaskInstanceDto.fromHistoricTaskInstance(taskInstance);
            result.add(taskInstanceDto);
        }
        return result;
    }

    @Override
    public CountResultDto getHistoricTaskInstancesCount(UriInfo uriInfo) {
        HistoricTaskInstanceQueryDto queryDto = new HistoricTaskInstanceQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricTaskInstancesCount(queryDto);
    }

    @Override
    public CountResultDto queryHistoricTaskInstancesCount(HistoricTaskInstanceQueryDto queryDto) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricTaskInstanceQuery query = (HistoricTaskInstanceQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    @Override
    public Response getHistoricTaskInstanceReport(UriInfo uriInfo) {
        Response response;
        HistoricTaskInstanceReportQueryDto queryDto = new HistoricTaskInstanceReportQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        if ("duration".equals(queryDto.getReportType())) {
            List<ReportResult> reportResults = queryDto.executeReport(this.processEngine);
            response = Response.ok(this.generateDurationDto(reportResults)).build();
        } else if ("count".equals(queryDto.getReportType())) {
            List<HistoricTaskInstanceReportResult> reportResults = queryDto.executeCompletedReport(this.processEngine);
            response = Response.ok(this.generateCountDto(reportResults)).build();
        } else {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Parameter reportType is not set.");
        }
        return response;
    }

    protected List<HistoricTaskInstanceReportResultDto> generateCountDto(List<HistoricTaskInstanceReportResult> results) {
        ArrayList<HistoricTaskInstanceReportResultDto> dtoList = new ArrayList<HistoricTaskInstanceReportResultDto>();
        for (HistoricTaskInstanceReportResult result : results) {
            dtoList.add(HistoricTaskInstanceReportResultDto.fromHistoricTaskInstanceReportResult(result));
        }
        return dtoList;
    }

    protected List<ReportResultDto> generateDurationDto(List<? extends ReportResult> results) {
        ArrayList<ReportResultDto> dtoList = new ArrayList<ReportResultDto>();
        for (ReportResult reportResult : results) {
            dtoList.add(ReportResultDto.fromReportResult(reportResult));
        }
        return dtoList;
    }
}

