/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.sub.history.impl;

import jakarta.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.AuthorizationException;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.history.HistoricExternalTaskLog;
import org.eximeebpms.bpm.engine.rest.dto.history.HistoricExternalTaskLogDto;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.sub.history.HistoricExternalTaskLogResource;

public class HistoricExternalTaskLogResourceImpl
implements HistoricExternalTaskLogResource {
    protected String id;
    protected ProcessEngine engine;

    public HistoricExternalTaskLogResourceImpl(String id, ProcessEngine engine) {
        this.id = id;
        this.engine = engine;
    }

    @Override
    public HistoricExternalTaskLogDto getHistoricExternalTaskLog() {
        HistoryService historyService = this.engine.getHistoryService();
        HistoricExternalTaskLog historicExternalTaskLog = (HistoricExternalTaskLog)historyService.createHistoricExternalTaskLogQuery().logId(this.id).singleResult();
        if (historicExternalTaskLog == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Historic external task log with id " + this.id + " does not exist");
        }
        return HistoricExternalTaskLogDto.fromHistoricExternalTaskLog(historicExternalTaskLog);
    }

    @Override
    public String getErrorDetails() {
        try {
            HistoryService historyService = this.engine.getHistoryService();
            return historyService.getHistoricExternalTaskLogErrorDetails(this.id);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, e.getMessage());
        }
    }
}

