/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.example.invoice;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;
import org.eximeebpms.bpm.application.ProcessApplicationReference;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.impl.util.IoUtil;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.repository.ProcessDefinitionQuery;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.example.invoice.DemoDataGenerator;

public class InvoiceApplicationHelper {
    private static final Logger LOGGER = Logger.getLogger(InvoiceApplicationHelper.class.getName());

    public static void startFirstProcess(ProcessEngine processEngine) {
        InvoiceApplicationHelper.createUsers(processEngine);
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)processEngine.getProcessEngineConfiguration();
        processEngineConfiguration.setDbMetricsReporterActivate(true);
        processEngineConfiguration.getDbMetricsReporter().setReporterId("REPORTER");
        InvoiceApplicationHelper.startProcessInstances(processEngine, "invoice", 1);
        InvoiceApplicationHelper.startProcessInstances(processEngine, "invoice", null);
        processEngineConfiguration.setDbMetricsReporterActivate(false);
    }

    public static void createDeployment(String processArchiveName, ProcessEngine processEngine, ClassLoader classLoader, ProcessApplicationReference applicationReference) {
        RepositoryService repositoryService;
        if (processEngine != null && !InvoiceApplicationHelper.isProcessDeployed(repositoryService = processEngine.getRepositoryService(), "invoice")) {
            repositoryService.createDeployment(applicationReference).addInputStream("invoice.v1.bpmn", classLoader.getResourceAsStream("invoice.v1.bpmn")).addInputStream("invoiceBusinessDecisions.dmn", classLoader.getResourceAsStream("invoiceBusinessDecisions.dmn")).addInputStream("reviewInvoice.bpmn", classLoader.getResourceAsStream("reviewInvoice.bpmn")).deploy();
        }
    }

    protected static boolean isProcessDeployed(RepositoryService repositoryService, String key) {
        return repositoryService.createProcessDefinitionQuery().processDefinitionKey("invoice").count() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void startProcessInstances(ProcessEngine processEngine, String processDefinitionKey, Integer version) {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)processEngine.getProcessEngineConfiguration();
        ProcessDefinitionQuery processDefinitionQuery = processEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey);
        if (version != null) {
            processDefinitionQuery.processDefinitionVersion(version);
        } else {
            processDefinitionQuery.latestVersion();
        }
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitionQuery.singleResult();
        InputStream invoiceInputStream = InvoiceApplicationHelper.class.getClassLoader().getResourceAsStream("invoice.pdf");
        long numberOfRunningProcessInstances = processEngine.getRuntimeService().createProcessInstanceQuery().processDefinitionId(processDefinition.getId()).count();
        if (numberOfRunningProcessInstances == 0L) {
            Task task;
            ProcessInstance pi;
            Calendar calendar;
            LOGGER.info("Start 3 instances of " + processDefinition.getName() + ", version " + processDefinition.getVersion());
            processEngine.getRuntimeService().startProcessInstanceById(processDefinition.getId(), (Map)Variables.createVariables().putValue("creditor", (Object)"Great Pizza for Everyone Inc.").putValue("amount", (Object)30.0).putValue("invoiceCategory", (Object)"Travel Expenses").putValue("invoiceNumber", (Object)"GPFE-23232323").putValue("invoiceDocument", (Object)Variables.fileValue((String)"invoice.pdf").file(invoiceInputStream).mimeType("application/pdf").create()));
            IoUtil.closeSilently((Closeable)invoiceInputStream);
            invoiceInputStream = InvoiceApplicationHelper.class.getClassLoader().getResourceAsStream("invoice.pdf");
            processEngineConfiguration.getDbMetricsReporter().reportNow();
            try {
                calendar = Calendar.getInstance();
                calendar.add(5, -14);
                ClockUtil.setCurrentTime((Date)calendar.getTime());
                pi = processEngine.getRuntimeService().startProcessInstanceById(processDefinition.getId(), (Map)Variables.createVariables().putValue("creditor", (Object)"Bobby's Office Supplies").putValue("amount", (Object)900.0).putValue("invoiceCategory", (Object)"Misc").putValue("invoiceNumber", (Object)"BOS-43934").putValue("invoiceDocument", (Object)Variables.fileValue((String)"invoice.pdf").file(invoiceInputStream).mimeType("application/pdf").create()));
                processEngineConfiguration.getDbMetricsReporter().reportNow();
                calendar.add(5, 14);
                ClockUtil.setCurrentTime((Date)calendar.getTime());
                processEngine.getIdentityService().setAuthentication("demo", Arrays.asList("eximeebpms-admin"));
                task = (Task)processEngine.getTaskService().createTaskQuery().processInstanceId(pi.getId()).singleResult();
                processEngine.getTaskService().claim(task.getId(), "demo");
                processEngine.getTaskService().complete(task.getId(), (Map)Variables.createVariables().putValue("approved", (Object)true));
            }
            finally {
                processEngineConfiguration.getDbMetricsReporter().reportNow();
                ClockUtil.reset();
                processEngine.getIdentityService().clearAuthentication();
            }
            IoUtil.closeSilently((Closeable)invoiceInputStream);
            invoiceInputStream = InvoiceApplicationHelper.class.getClassLoader().getResourceAsStream("invoice.pdf");
            try {
                calendar = Calendar.getInstance();
                calendar.add(5, -5);
                ClockUtil.setCurrentTime((Date)calendar.getTime());
                pi = processEngine.getRuntimeService().startProcessInstanceById(processDefinition.getId(), (Map)Variables.createVariables().putValue("creditor", (Object)"Papa Steve's all you can eat").putValue("amount", (Object)10.99).putValue("invoiceCategory", (Object)"Travel Expenses").putValue("invoiceNumber", (Object)"PSACE-5342").putValue("invoiceDocument", (Object)Variables.fileValue((String)"invoice.pdf").file(invoiceInputStream).mimeType("application/pdf").create()));
                processEngineConfiguration.getDbMetricsReporter().reportNow();
                calendar.add(5, 5);
                ClockUtil.setCurrentTime((Date)calendar.getTime());
                processEngine.getIdentityService().setAuthenticatedUserId("mary");
                task = (Task)processEngine.getTaskService().createTaskQuery().processInstanceId(pi.getId()).singleResult();
                processEngine.getTaskService().createComment(null, pi.getId(), "I cannot approve this invoice: the amount is missing.\n\n Could you please provide the amount?");
                processEngine.getTaskService().complete(task.getId(), (Map)Variables.createVariables().putValue("approved", (Object)false));
            }
            finally {
                processEngineConfiguration.getDbMetricsReporter().reportNow();
                ClockUtil.reset();
                processEngine.getIdentityService().clearAuthentication();
            }
        }
        LOGGER.info("No new instances of " + processDefinition.getName() + " version " + processDefinition.getVersion() + " started, there are " + numberOfRunningProcessInstances + " instances running");
    }

    protected static void createUsers(ProcessEngine processEngine) {
        new DemoDataGenerator().createUsers(processEngine);
    }
}

