/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.spring.boot.starter.webapp;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.SessionTrackingMode;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.Map;
import org.eximeebpms.bpm.admin.impl.web.AdminApplication;
import org.eximeebpms.bpm.admin.impl.web.bootstrap.AdminContainerBootstrap;
import org.eximeebpms.bpm.cockpit.impl.web.CockpitApplication;
import org.eximeebpms.bpm.cockpit.impl.web.bootstrap.CockpitContainerBootstrap;
import org.eximeebpms.bpm.engine.rest.filter.CacheControlFilter;
import org.eximeebpms.bpm.engine.rest.filter.EmptyBodyFilter;
import org.eximeebpms.bpm.spring.boot.starter.property.CamundaBpmProperties;
import org.eximeebpms.bpm.spring.boot.starter.property.WebappProperty;
import org.eximeebpms.bpm.spring.boot.starter.webapp.filter.AppendTrailingSlashFilter;
import org.eximeebpms.bpm.spring.boot.starter.webapp.filter.LazyProcessEnginesFilter;
import org.eximeebpms.bpm.spring.boot.starter.webapp.filter.LazySecurityFilter;
import org.eximeebpms.bpm.tasklist.impl.web.TasklistApplication;
import org.eximeebpms.bpm.tasklist.impl.web.bootstrap.TasklistContainerBootstrap;
import org.eximeebpms.bpm.webapp.impl.engine.EngineRestApplication;
import org.eximeebpms.bpm.webapp.impl.security.auth.AuthenticationFilter;
import org.eximeebpms.bpm.webapp.impl.security.filter.CsrfPreventionFilter;
import org.eximeebpms.bpm.webapp.impl.security.filter.SessionCookieFilter;
import org.eximeebpms.bpm.webapp.impl.security.filter.headersec.HttpHeaderSecurityFilter;
import org.eximeebpms.bpm.webapp.impl.security.filter.util.HttpSessionMutexListener;
import org.eximeebpms.bpm.webapp.impl.util.ServletContextUtil;
import org.eximeebpms.bpm.welcome.impl.web.WelcomeApplication;
import org.eximeebpms.bpm.welcome.impl.web.bootstrap.WelcomeContainerBootstrap;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.ServletContextInitializer;

public class CamundaBpmWebappInitializer
implements ServletContextInitializer {
    private static final Logger log = LoggerFactory.getLogger(CamundaBpmWebappInitializer.class);
    private static final EnumSet<DispatcherType> DISPATCHER_TYPES = EnumSet.of(DispatcherType.REQUEST);
    private ServletContext servletContext;
    private final CamundaBpmProperties properties;

    public CamundaBpmWebappInitializer(CamundaBpmProperties properties) {
        this.properties = properties;
    }

    public void onStartup(ServletContext servletContext) {
        this.servletContext = servletContext;
        servletContext.setSessionTrackingModes(Collections.singleton(SessionTrackingMode.COOKIE));
        servletContext.addListener((EventListener)new CockpitContainerBootstrap());
        servletContext.addListener((EventListener)new AdminContainerBootstrap());
        servletContext.addListener((EventListener)new TasklistContainerBootstrap());
        servletContext.addListener((EventListener)new WelcomeContainerBootstrap());
        servletContext.addListener((EventListener)new HttpSessionMutexListener());
        WebappProperty webapp = this.properties.getWebapp();
        String applicationPath = webapp.getApplicationPath();
        ServletContextUtil.setAppPath((String)applicationPath, (ServletContext)servletContext);
        this.registerFilter("AppendTrailingSlashFilter", AppendTrailingSlashFilter.class, applicationPath + "/app", applicationPath + "/app/cockpit", applicationPath + "/app/admin", applicationPath + "/app/tasklist", applicationPath + "/app/welcome");
        this.registerFilter("Authentication Filter", AuthenticationFilter.class, Collections.singletonMap("cacheTimeToLive", this.getAuthCacheTTL(webapp)), applicationPath + "/api/*", applicationPath + "/app/*");
        this.registerFilter("Security Filter", LazySecurityFilter.class, Collections.singletonMap("configFile", webapp.getSecurityConfigFile()), applicationPath + "/api/*", applicationPath + "/app/*");
        this.registerFilter("CsrfPreventionFilter", CsrfPreventionFilter.class, webapp.getCsrf().getInitParams(), applicationPath + "/api/*", applicationPath + "/app/*");
        this.registerFilter("SessionCookieFilter", SessionCookieFilter.class, webapp.getSessionCookie().getInitParams(), applicationPath + "/api/*", applicationPath + "/app/*");
        Map headerSecurityProperties = webapp.getHeaderSecurity().getInitParams();
        this.registerFilter("HttpHeaderSecurity", HttpHeaderSecurityFilter.class, headerSecurityProperties, applicationPath + "/api/*", applicationPath + "/app/*");
        this.registerFilter("Engines Filter", LazyProcessEnginesFilter.class, applicationPath + "/api/*", applicationPath + "/app/*", applicationPath + "/", applicationPath);
        this.registerFilter("EmptyBodyFilter", EmptyBodyFilter.class, applicationPath + "/api/*", applicationPath + "/app/*");
        this.registerFilter("CacheControlFilter", CacheControlFilter.class, applicationPath + "/api/*", applicationPath + "/app/*", applicationPath + "/assets/*");
        this.registerServlet("Cockpit Api", CockpitApplication.class, applicationPath + "/api/cockpit/*");
        this.registerServlet("Admin Api", AdminApplication.class, applicationPath + "/api/admin/*");
        this.registerServlet("Tasklist Api", TasklistApplication.class, applicationPath + "/api/tasklist/*");
        this.registerServlet("Engine Api", EngineRestApplication.class, applicationPath + "/api/engine/*");
        this.registerServlet("Welcome Api", WelcomeApplication.class, applicationPath + "/api/welcome/*");
    }

    protected String getAuthCacheTTL(WebappProperty webapp) {
        long authCacheTTL = webapp.getAuth().getCache().getTimeToLive();
        boolean authCacheTTLEnabled = webapp.getAuth().getCache().isTtlEnabled();
        if (authCacheTTLEnabled) {
            return Long.toString(authCacheTTL);
        }
        return "";
    }

    private FilterRegistration registerFilter(String filterName, Class<? extends Filter> filterClass, String ... urlPatterns) {
        return this.registerFilter(filterName, filterClass, (Map<String, String>)null, urlPatterns);
    }

    private FilterRegistration registerFilter(String filterName, Class<? extends Filter> filterClass, Map<String, String> initParameters, String ... urlPatterns) {
        FilterRegistration filterRegistration = this.servletContext.getFilterRegistration(filterName);
        if (filterRegistration == null) {
            filterRegistration = this.servletContext.addFilter(filterName, filterClass);
            filterRegistration.addMappingForUrlPatterns(DISPATCHER_TYPES, true, urlPatterns);
            if (initParameters != null) {
                filterRegistration.setInitParameters(initParameters);
            }
            log.debug("Filter {} for URL {} registered.", (Object)filterName, (Object)urlPatterns);
        }
        return filterRegistration;
    }

    private ServletRegistration registerServlet(String servletName, Class<?> applicationClass, String ... urlPatterns) {
        ServletRegistration servletRegistration = this.servletContext.getServletRegistration(servletName);
        if (servletRegistration == null) {
            servletRegistration = this.servletContext.addServlet(servletName, ServletContainer.class);
            servletRegistration.addMapping(urlPatterns);
            servletRegistration.setInitParameters(Collections.singletonMap("jakarta.ws.rs.Application", applicationClass.getName()));
            log.debug("Servlet {} for URL {} registered.", (Object)servletName, (Object)urlPatterns);
        }
        return servletRegistration;
    }
}

