/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.spring.boot.starter.webapp.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import org.eximeebpms.bpm.spring.boot.starter.property.WebappProperty;
import org.eximeebpms.bpm.spring.boot.starter.webapp.filter.ResourceLoaderDependingFilter;
import org.eximeebpms.bpm.webapp.impl.engine.ProcessEnginesFilter;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

public class ResourceLoadingProcessEnginesFilter
extends ProcessEnginesFilter
implements ResourceLoaderDependingFilter {
    protected static final String DEFAULT_REDIRECT_APP = "tasklist";
    protected ResourceLoader resourceLoader;
    protected WebappProperty webappProperty;

    protected void applyFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String appPath;
        String contextPath = request.getContextPath();
        String requestUri = request.getRequestURI().substring(contextPath.length());
        String applicationPath = this.webappProperty.getApplicationPath();
        if ((requestUri = this.trimChar(requestUri, '/')).equals(appPath = this.trimChar(applicationPath, '/')) && (!requestUri.isEmpty() || this.webappProperty.isIndexRedirectEnabled())) {
            response.sendRedirect(String.format("%s%s/app/%s/", contextPath, applicationPath, DEFAULT_REDIRECT_APP));
            return;
        }
        super.applyFilter(request, response, chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getWebResourceContents(String name) throws IOException {
        InputStream is = null;
        try {
            Resource resource = this.resourceLoader.getResource("classpath:" + this.webappProperty.getWebjarClasspath() + name);
            is = resource.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            StringWriter writer = new StringWriter();
            String line = null;
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.append("\n");
            }
            String string = writer.toString();
            return string;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public WebappProperty getWebappProperty() {
        return this.webappProperty;
    }

    @Override
    public void setWebappProperty(WebappProperty webappProperty) {
        this.webappProperty = webappProperty;
    }

    protected String trimChar(String input, char charachter) {
        input = StringUtils.trimLeadingCharacter((String)input, (char)charachter);
        input = StringUtils.trimTrailingCharacter((String)input, (char)charachter);
        return input;
    }
}

