/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.spring.boot.starter;

import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandExecutor;
import org.eximeebpms.bpm.engine.spring.ProcessEngineFactoryBean;
import org.eximeebpms.bpm.engine.spring.SpringProcessEngineServicesConfiguration;
import org.eximeebpms.bpm.spring.boot.starter.CamundaBpmActuatorConfiguration;
import org.eximeebpms.bpm.spring.boot.starter.CamundaBpmConfiguration;
import org.eximeebpms.bpm.spring.boot.starter.CamundaBpmPluginConfiguration;
import org.eximeebpms.bpm.spring.boot.starter.CamundaBpmTelemetryConfiguration;
import org.eximeebpms.bpm.spring.boot.starter.event.ProcessApplicationEventPublisher;
import org.eximeebpms.bpm.spring.boot.starter.property.CamundaBpmProperties;
import org.eximeebpms.bpm.spring.boot.starter.property.ManagementProperties;
import org.eximeebpms.bpm.spring.boot.starter.util.CamundaBpmVersion;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@EnableConfigurationProperties(value={CamundaBpmProperties.class, ManagementProperties.class})
@Import(value={CamundaBpmConfiguration.class, CamundaBpmActuatorConfiguration.class, CamundaBpmPluginConfiguration.class, CamundaBpmTelemetryConfiguration.class, SpringProcessEngineServicesConfiguration.class})
@Configuration
@ConditionalOnProperty(prefix="eximeebpms.bpm", name={"enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={HibernateJpaAutoConfiguration.class})
public class CamundaBpmAutoConfiguration {
    @Bean
    public CamundaBpmVersion camundaBpmVersion() {
        return new CamundaBpmVersion();
    }

    @Bean
    public ProcessApplicationEventPublisher processApplicationEventPublisher(ApplicationEventPublisher publisher) {
        return new ProcessApplicationEventPublisher(publisher);
    }

    @Configuration
    class ProcessEngineConfigurationImplDependingConfiguration {
        @Autowired
        protected ProcessEngineConfigurationImpl processEngineConfigurationImpl;

        ProcessEngineConfigurationImplDependingConfiguration() {
        }

        @Bean
        public ProcessEngineFactoryBean processEngineFactoryBean() {
            ProcessEngineFactoryBean factoryBean = new ProcessEngineFactoryBean();
            factoryBean.setProcessEngineConfiguration(this.processEngineConfigurationImpl);
            return factoryBean;
        }

        @Bean
        @Primary
        public CommandExecutor commandExecutorTxRequired() {
            return this.processEngineConfigurationImpl.getCommandExecutorTxRequired();
        }

        @Bean
        public CommandExecutor commandExecutorTxRequiresNew() {
            return this.processEngineConfigurationImpl.getCommandExecutorTxRequiresNew();
        }

        @Bean
        public CommandExecutor commandExecutorSchemaOperations() {
            return this.processEngineConfigurationImpl.getCommandExecutorSchemaOperations();
        }
    }
}

