/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.spring.boot.starter.configuration.impl;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.eximeebpms.bpm.engine.spring.SpringProcessEngineConfiguration;
import org.eximeebpms.bpm.spring.boot.starter.configuration.CamundaDeploymentConfiguration;
import org.eximeebpms.bpm.spring.boot.starter.configuration.impl.AbstractCamundaConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.ResourceArrayPropertyEditor;

public class DefaultDeploymentConfiguration
extends AbstractCamundaConfiguration
implements CamundaDeploymentConfiguration {
    private final Logger logger = LoggerFactory.getLogger(DefaultDeploymentConfiguration.class);

    @Override
    public void preInit(SpringProcessEngineConfiguration configuration) {
        if (this.camundaBpmProperties.isAutoDeploymentEnabled()) {
            Set<Resource> resources = this.getDeploymentResources();
            configuration.setDeploymentResources(resources.toArray(new Resource[resources.size()]));
            LOG.autoDeployResources(resources);
        }
    }

    @Override
    public Set<Resource> getDeploymentResources() {
        ResourceArrayPropertyEditor resolver = new ResourceArrayPropertyEditor();
        try {
            String[] resourcePattern = this.camundaBpmProperties.getDeploymentResourcePattern();
            this.logger.debug("resolving deployment resources for pattern {}", (Object[])resourcePattern);
            resolver.setValue((Object)resourcePattern);
            return Arrays.stream((Resource[])resolver.getValue()).peek(resource -> this.logger.debug("processing deployment resource {}", resource)).filter(this::isFile).peek(resource -> this.logger.debug("added deployment resource {}", resource)).collect(Collectors.toSet());
        }
        catch (RuntimeException e) {
            this.logger.error("unable to resolve resources", (Throwable)e);
            return Collections.EMPTY_SET;
        }
    }

    private boolean isFile(Resource resource) {
        if (resource.isReadable()) {
            if (resource instanceof UrlResource || resource instanceof ClassPathResource) {
                try {
                    URL url = resource.getURL();
                    return !url.toString().endsWith("/");
                }
                catch (IOException e) {
                    this.logger.debug("unable to handle " + resource + " as URL", (Throwable)e);
                }
            } else {
                try {
                    return !resource.getFile().isDirectory();
                }
                catch (IOException e) {
                    this.logger.debug("unable to handle " + resource + " as file", (Throwable)e);
                }
            }
        }
        this.logger.warn("unable to determine if resource {} is a deployable resource", (Object)resource);
        return false;
    }
}

