/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.spring.boot.starter.configuration.impl.custom;

import jakarta.annotation.PostConstruct;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.filter.Filter;
import org.eximeebpms.bpm.spring.boot.starter.configuration.impl.AbstractCamundaConfiguration;
import org.eximeebpms.bpm.spring.boot.starter.property.FilterProperty;

public class CreateFilterConfiguration
extends AbstractCamundaConfiguration {
    protected String filterName;

    @PostConstruct
    public void init() {
        this.filterName = Optional.ofNullable(this.camundaBpmProperties.getFilter()).map(FilterProperty::getCreate).orElseThrow(CreateFilterConfiguration.fail("filter.create not configured!"));
    }

    @Override
    public void postProcessEngineBuild(ProcessEngine processEngine) {
        Objects.requireNonNull(this.filterName);
        long filterCount = processEngine.getFilterService().createFilterQuery().filterName(this.filterName).count();
        if (filterCount == 0L) {
            Filter filter = processEngine.getFilterService().newTaskFilter(this.filterName);
            processEngine.getFilterService().saveFilter(filter);
            LOG.createInitialFilter(filter);
        } else {
            LOG.skipCreateInitialFilter(this.filterName);
        }
    }

    public String toString() {
        return this.createToString(Collections.singletonMap("filterName", this.filterName));
    }
}

