/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.spring.boot.starter.event;

import org.eximeebpms.bpm.spring.boot.starter.event.ProcessApplicationStartedEvent;
import org.eximeebpms.bpm.spring.boot.starter.event.ProcessApplicationStoppedEvent;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;

public class ProcessApplicationEventPublisher
implements ApplicationContextAware {
    private final ApplicationEventPublisher publisher;
    private ApplicationContext parentContext;

    public ProcessApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @EventListener
    public void handleApplicationReadyEvent(ApplicationReadyEvent applicationReadyEvent) {
        this.publisher.publishEvent((ApplicationEvent)new ProcessApplicationStartedEvent(applicationReadyEvent));
    }

    @EventListener
    public void handleContextStoppedEvent(ContextClosedEvent contextStoppedEvent) {
        if (this.parentContext == contextStoppedEvent.getApplicationContext()) {
            this.publisher.publishEvent((ApplicationEvent)new ProcessApplicationStoppedEvent(contextStoppedEvent));
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parentContext = applicationContext;
    }
}

