/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.spring.boot.starter.configuration.impl.custom;

import jakarta.annotation.PostConstruct;
import java.util.Objects;
import java.util.Optional;
import org.eximeebpms.bpm.engine.AuthorizationService;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.authorization.Authorization;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.identity.Group;
import org.eximeebpms.bpm.engine.identity.User;
import org.eximeebpms.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.eximeebpms.bpm.spring.boot.starter.configuration.impl.AbstractCamundaConfiguration;
import org.eximeebpms.bpm.spring.boot.starter.property.AdminUserProperty;
import org.springframework.beans.BeanUtils;

public class CreateAdminUserConfiguration
extends AbstractCamundaConfiguration {
    private User adminUser;

    @PostConstruct
    void init() {
        this.adminUser = Optional.ofNullable(this.camundaBpmProperties.getAdminUser()).map(AdminUserProperty::init).orElseThrow(CreateAdminUserConfiguration.fail("adminUser not configured!"));
    }

    @Override
    public void postProcessEngineBuild(ProcessEngine processEngine) {
        Objects.requireNonNull(this.adminUser);
        IdentityService identityService = processEngine.getIdentityService();
        AuthorizationService authorizationService = processEngine.getAuthorizationService();
        if (CreateAdminUserConfiguration.userAlreadyExists(identityService, this.adminUser)) {
            return;
        }
        CreateAdminUserConfiguration.createUser(identityService, this.adminUser);
        if (identityService.createGroupQuery().groupId("eximeebpms-admin").count() == 0L) {
            Group camundaAdminGroup = identityService.newGroup("eximeebpms-admin");
            camundaAdminGroup.setName("camunda BPM Administrators");
            camundaAdminGroup.setType("SYSTEM");
            identityService.saveGroup(camundaAdminGroup);
        }
        for (Resources resource : Resources.values()) {
            if (authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"eximeebpms-admin"}).resourceType((Resource)resource).resourceId("*").count() != 0L) continue;
            AuthorizationEntity userAdminAuth = new AuthorizationEntity(1);
            userAdminAuth.setGroupId("eximeebpms-admin");
            userAdminAuth.setResource((Resource)resource);
            userAdminAuth.setResourceId("*");
            userAdminAuth.addPermission((Permission)Permissions.ALL);
            authorizationService.saveAuthorization((Authorization)userAdminAuth);
        }
        identityService.createMembership(this.adminUser.getId(), "eximeebpms-admin");
        LOG.creatingInitialAdminUser(this.adminUser);
    }

    static boolean userAlreadyExists(IdentityService identityService, User adminUser) {
        User existingUser = (User)identityService.createUserQuery().userId(adminUser.getId()).singleResult();
        if (existingUser != null) {
            LOG.skipAdminUserCreation(existingUser);
            return true;
        }
        return false;
    }

    static User createUser(IdentityService identityService, User adminUser) {
        User newUser = identityService.newUser(adminUser.getId());
        BeanUtils.copyProperties((Object)adminUser, (Object)newUser);
        identityService.saveUser(newUser);
        return newUser;
    }
}

