/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.qa;

import jakarta.annotation.PostConstruct;
import org.apache.catalina.webresources.TomcatURLStreamHandlerFactory;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.example.invoice.InvoiceProcessApplication;
import org.eximeebpms.bpm.spring.boot.starter.annotation.EnableProcessApplication;
import org.eximeebpms.bpm.spring.boot.starter.event.PostDeployEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.event.EventListener;

@SpringBootApplication
@EnableProcessApplication(value="myProcessApplication")
public class Application {
    @Autowired
    protected ProcessEngine processEngine;
    protected InvoiceProcessApplication invoicePa = new InvoiceProcessApplication();

    public static void main(String[] args) {
        TomcatURLStreamHandlerFactory.disable();
        SpringApplication.run(Application.class, (String[])args);
    }

    @PostConstruct
    public void deployInvoice() {
        ClassLoader classLoader = this.invoicePa.getClass().getClassLoader();
        this.processEngine.getRepositoryService().createDeployment().addInputStream("invoice.v1.bpmn", classLoader.getResourceAsStream("invoice.v1.bpmn")).addInputStream("reviewInvoice.bpmn", classLoader.getResourceAsStream("reviewInvoice.bpmn")).deploy();
    }

    @EventListener
    public void onPostDeploy(PostDeployEvent event) {
        this.invoicePa.startFirstProcess(event.getProcessEngine());
    }
}

