/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.webapp.impl.security.auth;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.identity.Group;
import org.eximeebpms.bpm.engine.identity.Tenant;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.webapp.impl.WebappLogger;
import org.eximeebpms.bpm.webapp.impl.security.auth.Authentication;
import org.eximeebpms.bpm.webapp.impl.security.auth.AuthenticationDto;
import org.eximeebpms.bpm.webapp.impl.security.auth.AuthenticationUtil;
import org.eximeebpms.bpm.webapp.impl.security.auth.Authentications;
import org.eximeebpms.bpm.webapp.impl.security.auth.UserAuthentication;
import org.eximeebpms.bpm.webapp.impl.util.ProcessEngineUtil;
import org.eximeebpms.bpm.webapp.impl.util.ServletContextUtil;

@Path(value="/auth/user")
public class UserAuthenticationResource {
    protected static final WebappLogger LOGGER = WebappLogger.INSTANCE;
    public static final String PATH = "/auth/user";
    @Context
    protected HttpServletRequest request;

    @GET
    @Path(value="/{processEngineName}")
    public Response getAuthenticatedUser(@PathParam(value="processEngineName") String engineName) {
        Authentications allAuthentications = Authentications.getCurrent();
        if (allAuthentications == null) {
            return this.notFound();
        }
        Authentication engineAuth = allAuthentications.getAuthenticationForProcessEngine(engineName);
        if (engineAuth == null) {
            return this.notFound();
        }
        return Response.ok((Object)AuthenticationDto.fromAuthentication(engineAuth)).build();
    }

    @POST
    @Path(value="/{processEngineName}/login/{appName}")
    public Response doLogin(@PathParam(value="processEngineName") String engineName, @PathParam(value="appName") String appName, @FormParam(value="username") String username, @FormParam(value="password") String password) {
        Set<String> authorizedApps;
        ProcessEngine processEngine = ProcessEngineUtil.lookupProcessEngine(engineName);
        if (processEngine == null) {
            throw LOGGER.invalidRequestEngineNotFoundForName(engineName);
        }
        processEngine.getIdentityService().clearAuthentication();
        boolean isPasswordValid = processEngine.getIdentityService().checkPassword(username, password);
        if (!isPasswordValid) {
            if (this.isWebappsAuthenticationLoggingEnabled(processEngine)) {
                LOGGER.infoWebappFailedLogin(username, "bad credentials");
            }
            return this.unauthorized();
        }
        UserAuthentication authentication = AuthenticationUtil.createAuthentication(processEngine, username);
        if (authentication == null) {
            if (this.isWebappsAuthenticationLoggingEnabled(processEngine)) {
                LOGGER.infoWebappFailedLogin(username, "not authorized");
            }
            return this.unauthorized();
        }
        ServletContext servletContext = this.request.getServletContext();
        Date cacheValidationTime = ServletContextUtil.getAuthCacheValidationTime(servletContext);
        if (cacheValidationTime != null) {
            LOGGER.traceCacheValidationTime(cacheValidationTime);
            authentication.setCacheValidationTime(cacheValidationTime);
        }
        if (!(authorizedApps = authentication.getAuthorizedApps()).contains(appName)) {
            if (this.isWebappsAuthenticationLoggingEnabled(processEngine)) {
                LOGGER.infoWebappFailedLogin(username, "not authorized");
            }
            return this.forbidden();
        }
        if (this.request != null) {
            AuthenticationUtil.revalidateSession(this.request, authentication);
        }
        if (this.isWebappsAuthenticationLoggingEnabled(processEngine)) {
            LOGGER.infoWebappSuccessfulLogin(username);
        }
        return Response.ok((Object)AuthenticationDto.fromAuthentication(authentication)).build();
    }

    protected List<String> getGroupsOfUser(ProcessEngine engine, String userId) {
        List groups = engine.getIdentityService().createGroupQuery().groupMember(userId).list();
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Group group : groups) {
            groupIds.add(group.getId());
        }
        return groupIds;
    }

    protected List<String> getTenantsOfUser(ProcessEngine engine, String userId) {
        List tenants = engine.getIdentityService().createTenantQuery().userMember(userId).includingGroupsOfUser(true).list();
        ArrayList<String> tenantIds = new ArrayList<String>();
        for (Tenant tenant : tenants) {
            tenantIds.add(tenant.getId());
        }
        return tenantIds;
    }

    @POST
    @Path(value="/{processEngineName}/logout")
    public Response doLogout(@PathParam(value="processEngineName") String engineName) {
        Authentications authentications = Authentications.getCurrent();
        ProcessEngine processEngine = ProcessEngineUtil.lookupProcessEngine(engineName);
        if (processEngine == null) {
            throw LOGGER.invalidRequestEngineNotFoundForName(engineName);
        }
        if (authentications != null) {
            UserAuthentication removedAuthentication = authentications.removeByEngineName(engineName);
            if (this.isWebappsAuthenticationLoggingEnabled(processEngine) && removedAuthentication != null) {
                LOGGER.infoWebappLogout(removedAuthentication.getName());
            }
        }
        return Response.ok().build();
    }

    protected Response unauthorized() {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    protected Response forbidden() {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    protected Response notFound() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private boolean isWebappsAuthenticationLoggingEnabled(ProcessEngine processEngine) {
        return ((ProcessEngineConfigurationImpl)processEngine.getProcessEngineConfiguration()).isWebappsAuthenticationLoggingEnabled();
    }
}

